/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod;

import com.bluepowermod.BluePowerAPI;
import com.bluepowermod.ClientProxy;
import com.bluepowermod.CommonProxy;
import com.bluepowermod.api.BPApi;
import com.bluepowermod.api.power.CapabilityBlutricity;
import com.bluepowermod.api.wire.redstone.CapabilityRedstoneDevice;
import com.bluepowermod.client.gui.BPContainerType;
import com.bluepowermod.compat.CompatibilityUtils;
import com.bluepowermod.event.BPEventHandler;
import com.bluepowermod.event.BPRecyclingReloadListener;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPConfig;
import com.bluepowermod.init.BPEnchantments;
import com.bluepowermod.init.OreDictionarySetup;
import com.bluepowermod.init.Recipes;
import com.bluepowermod.network.BPNetworkHandler;
import com.bluepowermod.world.BPWorldGen;
import com.bluepowermod.world.WorldGenFlowers;
import com.bluepowermod.world.WorldGenOres;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.TableLootEntry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="bluepower")
public class BluePower {
    public static BluePower instance;
    public static CommonProxy proxy;
    public static Logger log;

    public BluePower() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, BPConfig.spec);
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(BPEnchantments.class);
        BPEventHandler eventHandler = new BPEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        BPApi.init(new BluePowerAPI());
        BPEnchantments.init();
        BPBlocks.init();
        proxy.preInitRenderers();
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(BPNetworkHandler::init);
        OreDictionarySetup.init();
        WorldGenOres.setupOres();
        WorldGenFlowers.setupFlowers();
        BPWorldGen.setupGeneralWorldGen();
        CapabilityBlutricity.register();
        CapabilityRedstoneDevice.register();
        proxy.setup(event);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> BPContainerType::registerScreenFactories);
        CompatibilityUtils.init(event);
    }

    @SubscribeEvent
    public void complete(FMLLoadCompleteEvent event) {
        proxy.initRenderers();
        CompatibilityUtils.postInit(event);
        Recipes.init();
    }

    @SubscribeEvent
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        event.getServer().func_195570_aG().func_219534_a((IFutureReloadListener)new BPRecyclingReloadListener(event.getServer()));
    }

    @SubscribeEvent
    public void onLootLoad(LootTableLoadEvent event) {
        ResourceLocation grass = new ResourceLocation("minecraft", "blocks/tall_grass");
        if (event.getName().equals((Object)grass)) {
            event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("bluepower", "blocks/tall_grass"))).name("bluepower:tall_grass").func_216044_b());
        }
    }

    @SubscribeEvent
    public void onServerStarted(FMLServerStartedEvent event) {
        if (((Boolean)BPConfig.CONFIG.alloyFurnaceDatapackGenerator.get()).booleanValue()) {
            event.getServer().func_193031_aM();
        }
    }

    static {
        proxy = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        log = LogManager.getLogger((String)"bluepower");
    }
}

