/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block;

import com.bluepowermod.api.multipart.IBPPartBlock;
import com.bluepowermod.block.BlockBPMultipart;
import com.bluepowermod.block.BlockBase;
import com.bluepowermod.tile.TileBPMultipart;
import com.bluepowermod.util.AABBUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;

public class BlockBPCableBase
extends BlockBase
implements IBPPartBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    protected static final BooleanProperty CONNECTED_FRONT = BooleanProperty.func_177716_a((String)"connected_front");
    protected static final BooleanProperty CONNECTED_BACK = BooleanProperty.func_177716_a((String)"connected_back");
    protected static final BooleanProperty CONNECTED_LEFT = BooleanProperty.func_177716_a((String)"connected_left");
    protected static final BooleanProperty CONNECTED_RIGHT = BooleanProperty.func_177716_a((String)"connected_right");
    protected static final BooleanProperty JOIN_FRONT = BooleanProperty.func_177716_a((String)"join_front");
    protected static final BooleanProperty JOIN_BACK = BooleanProperty.func_177716_a((String)"join_back");
    protected static final BooleanProperty JOIN_LEFT = BooleanProperty.func_177716_a((String)"join_left");
    protected static final BooleanProperty JOIN_RIGHT = BooleanProperty.func_177716_a((String)"join_right");
    protected final VoxelShape[] shapes;

    public BlockBPCableBase(float width, float height) {
        super(Material.field_151573_f);
        this.shapes = this.makeShapes(width, height);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.UP)).func_206870_a((IProperty)CONNECTED_FRONT, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)CONNECTED_BACK, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)CONNECTED_LEFT, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)JOIN_FRONT, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)JOIN_BACK, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)JOIN_LEFT, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)JOIN_RIGHT, (Comparable)Boolean.valueOf(false)));
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
        FACING.func_177700_c().forEach(f -> {
            BlockPos neighborPos = pos.func_177972_a(f).func_177972_a(((Direction)state.func_177229_b((IProperty)FACING)).func_176734_d());
            worldIn.func_180495_p(neighborPos).func_215697_a(worldIn, neighborPos, state.func_177230_c(), pos, isMoving);
        });
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity p_180633_4_, ItemStack p_180633_5_) {
        super.func_180633_a(worldIn, pos, state, p_180633_4_, p_180633_5_);
        FACING.func_177700_c().forEach(f -> {
            BlockPos neighborPos = pos.func_177972_a(f).func_177972_a(((Direction)state.func_177229_b((IProperty)FACING)).func_176734_d());
            worldIn.func_180495_p(neighborPos).func_215697_a(worldIn, neighborPos, state.func_177230_c(), pos, false);
        });
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return world.func_180495_p(pos.func_177972_a(((Direction)state.func_177229_b((IProperty)FACING)).func_176734_d())).func_200132_m();
    }

    protected Capability<?> getCapability() {
        return null;
    }

    private VoxelShape[] makeShapes(float width, float height) {
        float gap = 0.0f;
        float f = 8.0f - width;
        float f1 = 8.0f + width;
        float f2 = 8.0f - width;
        float f3 = 8.0f + width;
        VoxelShape voxelshape = Block.func_208617_a((double)f, (double)0.0, (double)f, (double)f1, (double)height, (double)f1);
        VoxelShape voxelshape1 = Block.func_208617_a((double)f2, (double)gap, (double)0.0, (double)f3, (double)height, (double)f3);
        VoxelShape voxelshape2 = Block.func_208617_a((double)f2, (double)gap, (double)f2, (double)f3, (double)height, (double)16.0);
        VoxelShape voxelshape3 = Block.func_208617_a((double)0.0, (double)gap, (double)f2, (double)f3, (double)height, (double)f3);
        VoxelShape voxelshape4 = Block.func_208617_a((double)f2, (double)gap, (double)f2, (double)16.0, (double)height, (double)f3);
        VoxelShape voxelshape5 = VoxelShapes.func_197872_a((VoxelShape)voxelshape1, (VoxelShape)voxelshape4);
        VoxelShape voxelshape6 = VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape3);
        VoxelShape[] avoxelshape = new VoxelShape[]{VoxelShapes.func_197880_a(), voxelshape2, voxelshape3, voxelshape6, voxelshape1, VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape1), VoxelShapes.func_197872_a((VoxelShape)voxelshape3, (VoxelShape)voxelshape1), VoxelShapes.func_197872_a((VoxelShape)voxelshape6, (VoxelShape)voxelshape1), voxelshape4, VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape4), VoxelShapes.func_197872_a((VoxelShape)voxelshape3, (VoxelShape)voxelshape4), VoxelShapes.func_197872_a((VoxelShape)voxelshape6, (VoxelShape)voxelshape4), voxelshape5, VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape5), VoxelShapes.func_197872_a((VoxelShape)voxelshape3, (VoxelShape)voxelshape5), VoxelShapes.func_197872_a((VoxelShape)voxelshape6, (VoxelShape)voxelshape5)};
        for (int i = 0; i < 16; ++i) {
            avoxelshape[i] = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)avoxelshape[i]);
        }
        return avoxelshape;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AABBUtils.rotate(this.shapes[this.getShapeIndex(state)], (Direction)state.func_177229_b((IProperty)FACING));
    }

    private int getShapeIndex(BlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((IProperty)CONNECTED_FRONT)).booleanValue()) {
            i |= BlockBPCableBase.getMask(Direction.NORTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)CONNECTED_BACK)).booleanValue()) {
            i |= BlockBPCableBase.getMask(Direction.SOUTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)CONNECTED_LEFT)).booleanValue()) {
            i |= BlockBPCableBase.getMask(Direction.WEST);
        }
        if (((Boolean)state.func_177229_b((IProperty)CONNECTED_RIGHT)).booleanValue()) {
            i |= BlockBPCableBase.getMask(Direction.EAST);
        }
        return i;
    }

    private static int getMask(Direction facing) {
        return 1 << facing.func_176736_b();
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean bool) {
        TileEntity te = world.func_175625_s(pos);
        BlockState newState = this.getStateForPos(world, pos, (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)), (Direction)state.func_177229_b((IProperty)FACING));
        if (!(te instanceof TileBPMultipart)) {
            world.func_180501_a(pos, newState, 2);
        } else {
            ((TileBPMultipart)te).changeState(state, newState);
        }
        state = newState;
        if (!world.func_180495_p(pos.func_177972_a(((Direction)state.func_177229_b((IProperty)FACING)).func_176734_d())).func_200132_m()) {
            if (te instanceof TileBPMultipart) {
                if (world instanceof ServerWorld) {
                    ((TileBPMultipart)te).removeState(state);
                    NonNullList drops = NonNullList.func_191196_a();
                    drops.add((Object)new ItemStack((IItemProvider)this));
                    InventoryHelper.func_219961_a((World)world, (BlockPos)pos, (NonNullList)drops);
                }
            } else {
                world.func_175655_b(pos, true);
            }
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, CONNECTED_FRONT, CONNECTED_BACK, CONNECTED_LEFT, CONNECTED_RIGHT, JOIN_FRONT, JOIN_BACK, JOIN_LEFT, JOIN_RIGHT});
    }

    private BlockState getStateForPos(World world, BlockPos pos, BlockState state, Direction face) {
        ArrayList<Direction> directions = new ArrayList<Direction>(FACING.func_177700_c());
        List internal = null;
        boolean connected_left = false;
        boolean connected_right = false;
        boolean connected_front = false;
        boolean connected_back = false;
        boolean join_left = false;
        boolean join_right = false;
        boolean join_front = false;
        boolean join_back = false;
        TileEntity ownTile = world.func_175625_s(pos);
        if (ownTile instanceof TileBPMultipart) {
            directions.removeIf(d -> ((TileBPMultipart)ownTile).isSideBlocked((Capability)this.getCapability(), (Direction)d));
            internal = ((TileBPMultipart)ownTile).getStates().stream().filter(s -> s.func_177230_c() == this).map(s -> (Direction)s.func_177229_b((IProperty)FACING)).collect(Collectors.toList());
        }
        directions.removeIf(d -> {
            TileEntity t = world.func_175625_s(pos.func_177972_a(d));
            return world.func_180495_p(pos.func_177972_a(d)).func_177230_c() == this && world.func_180495_p(pos.func_177972_a(d)).func_177229_b((IProperty)FACING) != face || t instanceof TileBPMultipart && ((TileBPMultipart)t).getStates().stream().noneMatch(s -> s.func_177229_b((IProperty)FACING) == face);
        });
        for (Direction d2 : directions) {
            TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(d2));
            boolean join = false;
            if (world.func_180495_p(pos.func_177972_a(d2)).func_177230_c() == Blocks.field_150350_a) {
                BlockState dirState = world.func_180495_p(pos.func_177972_a(d2).func_177972_a(face.func_176734_d()));
                if (dirState.func_177230_c() == this && dirState.func_177229_b((IProperty)FACING) == d2) {
                    tileEntity = world.func_175625_s(pos.func_177972_a(d2).func_177972_a(face.func_176734_d()));
                    join = true;
                } else if (dirState.func_177230_c() instanceof BlockBPMultipart) {
                    tileEntity = world.func_175625_s(pos.func_177972_a(d2).func_177972_a(face.func_176734_d()));
                    if (tileEntity instanceof TileBPMultipart && ((TileBPMultipart)tileEntity).getStates().stream().filter(s -> s.func_177230_c() == this).anyMatch(s -> s.func_177229_b((IProperty)FACING) == d2)) {
                        join = true;
                    } else {
                        tileEntity = null;
                    }
                }
            }
            if (tileEntity == null) continue;
            block0 : switch ((Direction)state.func_177229_b((IProperty)FACING)) {
                case UP: 
                case DOWN: {
                    switch (d2) {
                        case EAST: {
                            connected_right = tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            join_right = join && tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            break block0;
                        }
                        case WEST: {
                            connected_left = tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            join_left = join && tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            break block0;
                        }
                        case NORTH: {
                            connected_front = tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            join_front = join && tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            break block0;
                        }
                        case SOUTH: {
                            connected_back = tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            join_back = join && tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                        }
                    }
                    break;
                }
                case NORTH: {
                    switch (d2) {
                        case WEST: {
                            connected_right = tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            join_right = join && tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            break block0;
                        }
                        case EAST: {
                            connected_left = tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            join_left = join && tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            break block0;
                        }
                        case UP: {
                            connected_front = tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            join_front = join && tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            break block0;
                        }
                        case DOWN: {
                            connected_back = tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            join_back = join && tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                        }
                    }
                    break;
                }
                case SOUTH: {
                    switch (d2) {
                        case EAST: {
                            connected_right = tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            join_right = join && tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            break block0;
                        }
                        case WEST: {
                            connected_left = tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            join_left = join && tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            break block0;
                        }
                        case UP: {
                            connected_front = tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            join_front = join && tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            break block0;
                        }
                        case DOWN: {
                            connected_back = tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            join_back = join && tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                        }
                    }
                    break;
                }
                case EAST: {
                    switch (d2) {
                        case NORTH: {
                            connected_right = tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            join_right = join && tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            break block0;
                        }
                        case SOUTH: {
                            connected_left = tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            join_left = join && tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            break block0;
                        }
                        case UP: {
                            connected_front = tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            join_front = join && tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            break block0;
                        }
                        case DOWN: {
                            connected_back = tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            join_back = join && tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                        }
                    }
                    break;
                }
                case WEST: {
                    switch (d2) {
                        case SOUTH: {
                            connected_right = tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            join_right = join && tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            break block0;
                        }
                        case NORTH: {
                            connected_left = tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            join_left = join && tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            break block0;
                        }
                        case UP: {
                            connected_front = tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            join_front = join && tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            break block0;
                        }
                        case DOWN: {
                            connected_back = tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                            join_back = join && tileEntity.getCapability(this.getCapability(), d2.func_176734_d()).isPresent();
                        }
                    }
                }
            }
        }
        if (internal != null) {
            for (Direction d2 : internal) {
                block37 : switch ((Direction)state.func_177229_b((IProperty)FACING)) {
                    case UP: 
                    case DOWN: {
                        switch (d2) {
                            case EAST: {
                                connected_left = true;
                                break block37;
                            }
                            case WEST: {
                                connected_right = true;
                                break block37;
                            }
                            case NORTH: {
                                connected_back = true;
                                break block37;
                            }
                            case SOUTH: {
                                connected_front = true;
                            }
                        }
                        break;
                    }
                    case NORTH: {
                        switch (d2) {
                            case WEST: {
                                connected_left = true;
                                break block37;
                            }
                            case EAST: {
                                connected_right = true;
                                break block37;
                            }
                            case UP: {
                                connected_back = true;
                                break block37;
                            }
                            case DOWN: {
                                connected_front = true;
                            }
                        }
                        break;
                    }
                    case SOUTH: {
                        switch (d2) {
                            case EAST: {
                                connected_left = true;
                                break block37;
                            }
                            case WEST: {
                                connected_right = true;
                                break block37;
                            }
                            case UP: {
                                connected_back = true;
                                break block37;
                            }
                            case DOWN: {
                                connected_front = true;
                            }
                        }
                        break;
                    }
                    case EAST: {
                        switch (d2) {
                            case NORTH: {
                                connected_left = true;
                                break block37;
                            }
                            case SOUTH: {
                                connected_right = true;
                                break block37;
                            }
                            case UP: {
                                connected_back = true;
                                break block37;
                            }
                            case DOWN: {
                                connected_front = true;
                            }
                        }
                        break;
                    }
                    case WEST: {
                        switch (d2) {
                            case SOUTH: {
                                connected_left = true;
                                break block37;
                            }
                            case NORTH: {
                                connected_right = true;
                                break block37;
                            }
                            case UP: {
                                connected_back = true;
                                break block37;
                            }
                            case DOWN: {
                                connected_front = true;
                            }
                        }
                    }
                }
            }
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)CONNECTED_LEFT, (Comparable)Boolean.valueOf(connected_left))).func_206870_a((IProperty)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(connected_right))).func_206870_a((IProperty)CONNECTED_FRONT, (Comparable)Boolean.valueOf(connected_front))).func_206870_a((IProperty)CONNECTED_BACK, (Comparable)Boolean.valueOf(connected_back))).func_206870_a((IProperty)JOIN_LEFT, (Comparable)Boolean.valueOf(join_left))).func_206870_a((IProperty)JOIN_RIGHT, (Comparable)Boolean.valueOf(join_right))).func_206870_a((IProperty)JOIN_FRONT, (Comparable)Boolean.valueOf(join_front))).func_206870_a((IProperty)JOIN_BACK, (Comparable)Boolean.valueOf(join_back));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getStateForPos(context.func_195991_k(), context.func_195995_a(), (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_196000_l()), context.func_196000_l());
    }

    @Override
    public VoxelShape getOcclusionShape(BlockState state) {
        return AABBUtils.rotate(this.shapes[this.getShapeIndex(state)], (Direction)state.func_177229_b((IProperty)FACING));
    }
}

