/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.machine;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.block.machine.BlockLamp;
import com.bluepowermod.util.AABBUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockLampSurface
extends BlockLamp
implements IWaterLoggable {
    private final VoxelShape size;
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public BlockLampSurface(String name, boolean isInverted, MinecraftColor color, VoxelShape size) {
        super(name, isInverted, color);
        this.size = size;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)POWER, (Comparable)Integer.valueOf(isInverted ? 15 : 0))).func_206870_a((IProperty)FACING, (Comparable)Direction.UP)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AABBUtils.rotate(this.size, (Direction)state.func_177229_b((IProperty)FACING));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{POWER, FACING, WATERLOGGED});
    }

    @Override
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean bool) {
        super.func_220069_a(state, world, pos, blockIn, fromPos, bool);
        if (!world.func_180495_p(pos.func_177972_a(((Direction)state.func_177229_b((IProperty)FACING)).func_176734_d())).func_200132_m()) {
            world.func_175655_b(pos, true);
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return world.func_180495_p(pos.func_177972_a(((Direction)state.func_177229_b((IProperty)FACING)).func_176734_d())).func_200132_m();
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)super.func_196258_a(context).func_206870_a((IProperty)FACING, (Comparable)context.func_196000_l())).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState getStateForPlacement(BlockState state, Direction facing, BlockState state2, IWorld world, BlockPos pos1, BlockPos pos2, Hand hand) {
        return (BlockState)super.getStateForPlacement(state, facing, state2, world, pos1, pos2, hand).func_206870_a((IProperty)FACING, (Comparable)facing);
    }
}

