/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.gui.widget;

import com.bluepowermod.client.gui.widget.IGuiWidget;
import com.bluepowermod.client.gui.widget.IWidgetListener;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import org.lwjgl.opengl.GL11;

public class BaseWidget
implements IGuiWidget {
    private final int id;
    public int value;
    protected final int x;
    protected final int y;
    protected final int width;
    protected final int height;
    private final int textureU;
    private final int textureV;
    protected final ResourceLocation[] textures;
    protected int textureIndex = 0;
    protected IWidgetListener gui;
    public boolean enabled = true;

    public BaseWidget(int id, int x, int y, int width, int height, String ... textureLocs) {
        this(id, x, y, width, height, 0, 0, textureLocs);
    }

    public BaseWidget(int id, int x, int y, int width, int height, int textureU, int textureV, String ... textureLocs) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.textureU = textureU;
        this.textureV = textureV;
        this.textures = new ResourceLocation[textureLocs.length];
        for (int i = 0; i < this.textures.length; ++i) {
            this.textures[i] = new ResourceLocation(textureLocs[i]);
        }
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void setListener(IWidgetListener gui) {
        this.gui = gui;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        if (this.enabled) {
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        } else {
            GL11.glColor4d((double)0.2, (double)0.2, (double)0.2, (double)1.0);
        }
        if (this.textures.length > 0) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.textures[this.textureIndex]);
        }
        AbstractGui.blit((int)this.x, (int)this.y, (float)this.getTextureU(), (float)this.getTextureV(), (int)this.width, (int)this.height, (int)this.getTextureWidth(), (int)this.getTextureHeight());
    }

    protected int getTextureU() {
        return this.textureU;
    }

    protected int getTextureV() {
        return this.textureV;
    }

    protected int getTextureWidth() {
        return this.width;
    }

    protected int getTextureHeight() {
        return this.height;
    }

    @Override
    public void onMouseClicked(int mouseX, int mouseY, int button) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        this.gui.actionPerformed(this);
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    @Override
    public void addTooltip(int mouseX, int mouseY, List<String> curTip, boolean shiftPressed) {
    }

    @Override
    public void update() {
    }
}

