/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.render;

import com.bluepowermod.block.BlockBPMicroblock;
import com.bluepowermod.block.gates.BlockGateBase;
import com.bluepowermod.block.machine.BlockLampSurface;
import com.bluepowermod.block.power.BlockBattery;
import com.bluepowermod.block.worldgen.BlockBPGlass;
import com.bluepowermod.client.render.BPBlockColor;
import com.bluepowermod.client.render.BPItemColor;
import com.bluepowermod.client.render.BPMicroblockModel;
import com.bluepowermod.client.render.BPMultipartModel;
import com.bluepowermod.client.render.IBPColoredBlock;
import com.bluepowermod.client.render.IBPColoredItem;
import com.bluepowermod.client.render.ICustomModelBlock;
import com.bluepowermod.client.render.RenderEngine;
import com.bluepowermod.client.render.RenderLamp;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPItems;
import com.bluepowermod.tile.BPTileEntityType;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class Renderers {
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent evt) {
        for (Block block : BPBlocks.blockList) {
            if (!(block instanceof ICustomModelBlock)) continue;
            Renderers.registerBakedModel(block);
        }
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        event.getModelRegistry().put(new ModelResourceLocation("bluepower:multipart"), new BPMultipartModel());
        BPMicroblockModel microblockModel = new BPMicroblockModel();
        for (Direction dir : Direction.values()) {
            event.getModelRegistry().put(new ModelResourceLocation("bluepower:half_block", "face=" + dir.func_176610_l()), event.getModelRegistry().get(new ModelResourceLocation("bluepower:half_block", "facing=" + dir.func_176610_l() + ",waterlogged=true")));
            event.getModelRegistry().put(new ModelResourceLocation("bluepower:half_block", "facing=" + dir.func_176610_l() + ",waterlogged=true"), microblockModel);
            event.getModelRegistry().put(new ModelResourceLocation("bluepower:half_block", "facing=" + dir.func_176610_l() + ",waterlogged=false"), microblockModel);
            event.getModelRegistry().put(new ModelResourceLocation("bluepower:panel", "face=" + dir.func_176610_l()), event.getModelRegistry().get(new ModelResourceLocation("bluepower:panel", "facing=" + dir.func_176610_l() + ",waterlogged=true")));
            event.getModelRegistry().put(new ModelResourceLocation("bluepower:panel", "facing=" + dir.func_176610_l() + ",waterlogged=true"), microblockModel);
            event.getModelRegistry().put(new ModelResourceLocation("bluepower:panel", "facing=" + dir.func_176610_l() + ",waterlogged=false"), microblockModel);
            event.getModelRegistry().put(new ModelResourceLocation("bluepower:cover", "face=" + dir.func_176610_l()), event.getModelRegistry().get(new ModelResourceLocation("bluepower:cover", "facing=" + dir.func_176610_l() + ",waterlogged=true")));
            event.getModelRegistry().put(new ModelResourceLocation("bluepower:cover", "facing=" + dir.func_176610_l() + ",waterlogged=true"), microblockModel);
            event.getModelRegistry().put(new ModelResourceLocation("bluepower:cover", "facing=" + dir.func_176610_l() + ",waterlogged=false"), microblockModel);
        }
        event.getModelRegistry().put(new ModelResourceLocation("bluepower:half_block", "inventory"), microblockModel);
        event.getModelRegistry().put(new ModelResourceLocation("bluepower:panel", "inventory"), microblockModel);
        event.getModelRegistry().put(new ModelResourceLocation("bluepower:cover", "inventory"), microblockModel);
    }

    public static void init() {
        ClientRegistry.bindTileEntityRenderer(BPTileEntityType.LAMP, RenderLamp::new);
        ClientRegistry.bindTileEntityRenderer(BPTileEntityType.ENGINE, RenderEngine::new);
        for (Item item : BPItems.itemList) {
            if (!(item instanceof IBPColoredItem)) continue;
            Minecraft.func_71410_x().getItemColors().func_199877_a((IItemColor)new BPItemColor(), new IItemProvider[]{item});
        }
        for (Block block : BPBlocks.blockList) {
            if (block instanceof IBPColoredBlock) {
                Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)new BPBlockColor(), new Block[]{block});
                Minecraft.func_71410_x().getItemColors().func_199877_a((IItemColor)new BPBlockColor(), new IItemProvider[]{Item.func_150898_a((Block)block)});
            }
            if (block instanceof BlockLampSurface || block instanceof BlockGateBase || block instanceof BlockBattery) {
                RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228643_e_());
            }
            if (!(block instanceof BlockBPGlass) && !(block instanceof BlockBPMicroblock)) continue;
            RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228645_f_());
        }
        RenderTypeLookup.setRenderLayer((Block)BPBlocks.indigo_flower, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)BPBlocks.flax_crop, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)BPBlocks.cracked_basalt_lava, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)BPBlocks.rubber_leaves, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)BPBlocks.rubber_sapling, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)BPBlocks.tube, (RenderType)RenderType.func_228643_e_());
    }

    public static void registerBakedModel(Block block) {
        ((ICustomModelBlock)block).initModel();
    }
}

