/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier3;

import com.bluepowermod.api.power.BlutricityFEStorage;
import com.bluepowermod.api.power.CapabilityBlutricity;
import com.bluepowermod.block.power.BlockEngine;
import com.bluepowermod.tile.BPTileEntityType;
import com.bluepowermod.tile.TileMachineBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;

public class TileEngine
extends TileMachineBase {
    private Direction orientation;
    public boolean isActive = false;
    public byte pumpTick = 0;
    public byte pumpSpeed;
    private final BlutricityFEStorage storage = new BlutricityFEStorage(320.0){

        @Override
        public boolean canReceive() {
            return false;
        }
    };
    private LazyOptional<BlutricityFEStorage> blutricityCap;

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityBlutricity.BLUTRICITY_CAPABILITY || cap == CapabilityEnergy.ENERGY) {
            if (this.blutricityCap == null) {
                this.blutricityCap = LazyOptional.of(() -> this.storage);
            }
            return this.blutricityCap.cast();
        }
        return LazyOptional.empty();
    }

    public TileEngine() {
        super(BPTileEntityType.ENGINE);
        this.pumpSpeed = (byte)16;
    }

    @Override
    public void func_73660_a() {
        Direction facing;
        TileEntity tileEntity;
        super.func_73660_a();
        this.storage.resetCurrent();
        this.isActive = false;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.storage.getEnergyStored() > 0 && this.field_145850_b.func_175640_z(this.field_174879_c) && (tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing = ((Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockEngine.FACING)).func_176734_d()))) != null) {
            tileEntity.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()).ifPresent(other -> {
                int simulated = this.storage.extractEnergy(320, true);
                int sent = other.receiveEnergy(simulated, false);
                int amount = this.storage.extractEnergy(sent, false);
                if (amount > 0) {
                    this.isActive = true;
                }
            });
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockEngine.ACTIVE) != this.isActive) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((IProperty)BlockEngine.ACTIVE, (Comparable)Boolean.valueOf(this.isActive)));
            this.markForRenderUpdate();
        }
        if (this.field_145850_b != null && ((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockEngine.ACTIVE)).booleanValue()) {
            this.isActive = true;
            this.pumpTick = (byte)(this.pumpTick + 1);
            if (this.pumpTick >= this.pumpSpeed * 2) {
                this.pumpTick = 0;
                if (this.pumpSpeed > 4) {
                    this.pumpSpeed = (byte)(this.pumpSpeed - 1);
                }
            }
        } else {
            this.isActive = false;
            this.pumpTick = 0;
        }
    }

    public void setOrientation(Direction orientation) {
        this.orientation = orientation;
        this.func_70296_d();
    }

    public Direction getOrientation() {
        return this.orientation;
    }

    @Override
    protected void writeToPacketNBT(CompoundNBT compound) {
        super.writeToPacketNBT(compound);
        int rotation = this.orientation.func_176745_a();
        compound.func_74768_a("rotation", rotation);
        compound.func_74774_a("pumpspeed", this.pumpSpeed);
        compound.func_74774_a("pumptick", this.pumpTick);
        INBT nbtstorage = CapabilityBlutricity.BLUTRICITY_CAPABILITY.getStorage().writeNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, (Object)this.storage, null);
        compound.func_218657_a("energy", nbtstorage);
    }

    @Override
    protected void readFromPacketNBT(CompoundNBT compound) {
        super.readFromPacketNBT(compound);
        this.orientation = Direction.func_82600_a((int)compound.func_74762_e("rotation"));
        this.pumpSpeed = compound.func_74771_c("pumpspeed");
        this.pumpTick = compound.func_74771_c("pumptick");
        if (compound.func_74764_b("energy")) {
            INBT nbtstorage = compound.func_74781_a("energy");
            CapabilityBlutricity.BLUTRICITY_CAPABILITY.getStorage().readNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, (Object)this.storage, null, nbtstorage);
        }
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        if (this.blutricityCap != null) {
            this.blutricityCap.invalidate();
            this.blutricityCap = null;
        }
    }
}

