/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.ILexiconable;
import vazkii.botania.api.IWandHUD;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.item.ModItems;

public final class HUDHandler {
    private static final ResourceLocation manaBar = new ResourceLocation("botania:textures/gui/manaHud.png");
    private static final RenderItem itemRender = new RenderItem();

    @ForgeSubscribe
    public void onDrawScreen(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.ALL) {
            LexiconEntry entry;
            int id;
            Minecraft mc = Minecraft.func_71410_x();
            MovingObjectPosition pos = mc.field_71476_x;
            if (pos != null && mc.field_71439_g.func_71045_bC() != null && mc.field_71439_g.func_71045_bC().field_77993_c == ModItems.twigWand.field_77779_bT) {
                int id2 = mc.field_71441_e.func_72798_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                if (Block.field_71973_m[id2] != null && Block.field_71973_m[id2] instanceof IWandHUD) {
                    ((IWandHUD)Block.field_71973_m[id2]).renderHUD(mc, event.resolution, (World)mc.field_71441_e, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                }
            } else if (pos != null && mc.field_71439_g.func_71045_bC() != null && mc.field_71439_g.func_71045_bC().field_77993_c == ModItems.lexicon.field_77779_bT && Block.field_71973_m[id = mc.field_71441_e.func_72798_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d)] != null && Block.field_71973_m[id] instanceof ILexiconable && (entry = ((ILexiconable)Block.field_71973_m[id]).getEntry((World)mc.field_71441_e, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, (EntityPlayer)mc.field_71439_g, mc.field_71439_g.func_71045_bC())) != null) {
                this.drawLexiconGUI(entry, event.resolution);
            }
        }
    }

    private void drawLexiconGUI(LexiconEntry entry, ScaledResolution res) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Minecraft mc = Minecraft.func_71410_x();
        int x = res.func_78326_a() / 2 + 8;
        int y = res.func_78328_b() / 2 - 4;
        int color = 0x6600FF00;
        mc.field_71466_p.func_78261_a(StatCollector.func_74838_a((String)entry.getUnlocalizedName()), x + 18, y, color);
        mc.field_71466_p.func_78261_a(StatCollector.func_74838_a((String)"botaniamisc.shiftToRead"), x + 18, y + 11, color);
        itemRender.func_77015_a(mc.field_71466_p, mc.field_71446_o, new ItemStack(ModItems.lexicon), x, y);
        GL11.glDisable((int)2896);
        mc.field_71466_p.func_78261_a("?", x + 10, y + 8, 0xFFFFFF);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawSimpleManaHUD(int color, int mana, int maxMana, String name, ScaledResolution res) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Minecraft mc = Minecraft.func_71410_x();
        int x = res.func_78326_a() / 2 - mc.field_71466_p.func_78256_a(name) / 2;
        int y = res.func_78328_b() / 2 + 10;
        mc.field_71466_p.func_78261_a(name, x, y, color);
        x = res.func_78326_a() / 2 - 51;
        HUDHandler.renderManaBar(x, y += 10, color, 0.5f, mana, maxMana);
        if (mana < 0) {
            String text = StatCollector.func_74838_a((String)"botaniamisc.statusUnknown");
            x = res.func_78326_a() / 2 - mc.field_71466_p.func_78256_a(text) / 2;
            mc.field_71466_p.func_78261_a(text, x, --y, color);
        }
        GL11.glDisable((int)3042);
    }

    public static void renderManaBar(int x, int y, int color, float alpha, int mana, int maxMana) {
        Minecraft mc = Minecraft.func_71410_x();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        mc.field_71446_o.func_110577_a(manaBar);
        RenderHelper.drawTexturedModalRect(x, y, 0.0f, 0, 0, 102, 5);
        int manaPercentage = Math.max(0, (int)((double)mana / (double)maxMana * 100.0));
        if (manaPercentage == 0 && mana > 0) {
            manaPercentage = 1;
        }
        RenderHelper.drawTexturedModalRect(x + 1 + manaPercentage, y + 1, 0.0f, 0, 5, 100 - manaPercentage, 3);
        Color color_ = new Color(color);
        GL11.glColor4ub((byte)((byte)color_.getRed()), (byte)((byte)color_.getGreen()), (byte)((byte)color_.getBlue()), (byte)((byte)(255.0f * alpha)));
        RenderHelper.drawTexturedModalRect(x + 1, y + 1, 0.0f, 0, 5, manaPercentage, 3);
    }
}

