/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.proxy;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.client.core.handler.BoundTileRenderer;
import vazkii.botania.client.core.handler.CapeHandler;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.client.core.handler.LightningHandler;
import vazkii.botania.client.fx.FXSparkle;
import vazkii.botania.client.fx.FXWisp;
import vazkii.botania.client.gui.GuiLexicon;
import vazkii.botania.client.gui.GuiLexiconEntry;
import vazkii.botania.client.gui.GuiLexiconIndex;
import vazkii.botania.client.lib.LibRenderIDs;
import vazkii.botania.client.render.block.RenderAltar;
import vazkii.botania.client.render.block.RenderPool;
import vazkii.botania.client.render.block.RenderPylon;
import vazkii.botania.client.render.block.RenderSpecialFlower;
import vazkii.botania.client.render.block.RenderSpreader;
import vazkii.botania.client.render.item.RenderLens;
import vazkii.botania.client.render.item.RenderLexicon;
import vazkii.botania.client.render.tile.RenderTileAltar;
import vazkii.botania.client.render.tile.RenderTileEnchanter;
import vazkii.botania.client.render.tile.RenderTilePool;
import vazkii.botania.client.render.tile.RenderTilePylon;
import vazkii.botania.client.render.tile.RenderTileRuneAltar;
import vazkii.botania.client.render.tile.RenderTileSpreader;
import vazkii.botania.common.block.tile.TileAltar;
import vazkii.botania.common.block.tile.TileEnchanter;
import vazkii.botania.common.block.tile.TilePool;
import vazkii.botania.common.block.tile.TilePylon;
import vazkii.botania.common.block.tile.TileRuneAltar;
import vazkii.botania.common.block.tile.TileSpreader;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.core.proxy.CommonProxy;
import vazkii.botania.common.item.ModItems;

public class ClientProxy
extends CommonProxy {
    private static boolean distanceLimit = true;

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        TickRegistry.registerTickHandler((ITickHandler)new ClientTickHandler(), (Side)Side.CLIENT);
        MinecraftForge.EVENT_BUS.register((Object)new HUDHandler());
        MinecraftForge.EVENT_BUS.register((Object)new LightningHandler());
        MinecraftForge.EVENT_BUS.register((Object)new CapeHandler());
        if (ConfigHandler.boundBlockWireframe) {
            MinecraftForge.EVENT_BUS.register((Object)new BoundTileRenderer());
        }
        this.initRenderers();
    }

    private void initRenderers() {
        LibRenderIDs.idAltar = RenderingRegistry.getNextAvailableRenderId();
        LibRenderIDs.idSpecialFlower = RenderingRegistry.getNextAvailableRenderId();
        LibRenderIDs.idSpreader = RenderingRegistry.getNextAvailableRenderId();
        LibRenderIDs.idPool = RenderingRegistry.getNextAvailableRenderId();
        LibRenderIDs.idPylon = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderAltar());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderSpecialFlower(LibRenderIDs.idSpecialFlower));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderSpreader());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderPool());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderPylon());
        MinecraftForgeClient.registerItemRenderer((int)ModItems.lens.field_77779_bT, (IItemRenderer)new RenderLens());
        if (ConfigHandler.lexicon3dModel) {
            MinecraftForgeClient.registerItemRenderer((int)ModItems.lexicon.field_77779_bT, (IItemRenderer)new RenderLexicon());
        }
        ClientRegistry.bindTileEntitySpecialRenderer(TileAltar.class, (TileEntitySpecialRenderer)new RenderTileAltar());
        ClientRegistry.bindTileEntitySpecialRenderer(TileSpreader.class, (TileEntitySpecialRenderer)new RenderTileSpreader());
        ClientRegistry.bindTileEntitySpecialRenderer(TilePool.class, (TileEntitySpecialRenderer)new RenderTilePool());
        ClientRegistry.bindTileEntitySpecialRenderer(TileRuneAltar.class, (TileEntitySpecialRenderer)new RenderTileRuneAltar());
        ClientRegistry.bindTileEntitySpecialRenderer(TilePylon.class, (TileEntitySpecialRenderer)new RenderTilePylon());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEnchanter.class, (TileEntitySpecialRenderer)new RenderTileEnchanter());
    }

    @Override
    public void setEntryToOpen(LexiconEntry entry) {
        GuiLexicon.currentOpenLexicon = new GuiLexiconEntry(entry, new GuiLexiconIndex(entry.category));
    }

    @Override
    public long getWorldElapsedTicks() {
        return Minecraft.func_71410_x().field_71441_e == null ? 0L : Minecraft.func_71410_x().field_71441_e.func_82737_E();
    }

    @Override
    public void sparkleFX(World world, double x, double y, double z, float r, float g, float b, float size, int m, boolean fake) {
        FXSparkle sparkle = new FXSparkle(world, x, y, z, size, r, g, b, m);
        sparkle.fake = sparkle.field_70145_X = fake;
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)sparkle);
    }

    @Override
    public void setWispFXDistanceLimit(boolean limit) {
        distanceLimit = limit;
    }

    @Override
    public void wispFX(World world, double x, double y, double z, float r, float g, float b, float size, float motionx, float motiony, float motionz) {
        FXWisp wisp = new FXWisp(world, x, y, z, size, r, g, b, distanceLimit);
        wisp.field_70159_w = motionx;
        wisp.field_70181_x = motiony;
        wisp.field_70179_y = motionz;
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)wisp);
    }

    @Override
    public void lightningFX(World world, Vector3 vectorStart, Vector3 vectorEnd, float ticksPerMeter, long seed, int colorOuter, int colorInner) {
        LightningHandler.spawnLightningBolt(world, vectorStart, vectorEnd, ticksPerMeter, seed, colorOuter, colorInner);
    }
}

