/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.WorldEvent;
import vazkii.botania.api.ILexiconable;
import vazkii.botania.api.IWandable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.lexicon.LexiconData;
import vazkii.botania.common.lib.LibBlockIDs;

public class BlockPistonRelay
extends BlockMod
implements IWandable,
ILexiconable {
    public BlockPistonRelay() {
        super(LibBlockIDs.idPistonRelay, Material.field_76266_z);
        this.func_71864_b("botania:pistonRelay");
        this.func_71848_c(2.0f);
        this.func_71894_b(10.0f);
        this.func_71884_a(field_71977_i);
        TickRegistry.registerTickHandler((ITickHandler)new InternalTickHandler(), (Side)Side.SERVER);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int func_71885_a(int par1, Random par2Random, int par3) {
        return 0;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 0;
    }

    public boolean func_71926_d() {
        return false;
    }

    public void func_71852_a(World par1World, int par2, int par3, int par4, int par5, int par6) {
        BlockPistonRelay.mapCoords(par1World.field_73011_w.field_76574_g, par2, par3, par4, 2);
    }

    public static String getCoordsAsString(int world, int x, int y, int z) {
        return world + ":" + x + ":" + y + ":" + z;
    }

    static void mapCoords(int world, int x, int y, int z, int time) {
        InternalTickHandler.coordsToCheck.put(BlockPistonRelay.getCoordsAsString(world, x, y, z), time);
    }

    static void decrCoords(String key) {
        int time = BlockPistonRelay.getTimeInCoords(key);
        if (time <= 0) {
            InternalTickHandler.removeThese.add(key);
        } else {
            InternalTickHandler.coordsToCheck.put(key, time - 1);
        }
    }

    static int getTimeInCoords(String key) {
        return InternalTickHandler.coordsToCheck.get(key);
    }

    static int getBlockIDAt(String key) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server == null) {
            return 0;
        }
        String[] tokens = key.split(":");
        int worldId = Integer.parseInt(tokens[0]);
        int x = Integer.parseInt(tokens[1]);
        int y = Integer.parseInt(tokens[2]);
        int z = Integer.parseInt(tokens[3]);
        WorldServer world = server.func_71218_a(worldId);
        return world.func_72798_a(x, y, z);
    }

    static int getBlockMetaAt(String key) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server == null) {
            return 0;
        }
        String[] tokens = key.split(":");
        int worldId = Integer.parseInt(tokens[0]);
        int x = Integer.parseInt(tokens[1]);
        int y = Integer.parseInt(tokens[2]);
        int z = Integer.parseInt(tokens[3]);
        WorldServer world = server.func_71218_a(worldId);
        return world.func_72805_g(x, y, z);
    }

    @Override
    public boolean onUsedByWand(EntityPlayer player, ItemStack stack, World world, int x, int y, int z, int side) {
        if (!player.func_70093_af()) {
            InternalTickHandler.playerPositions.put(player.field_71092_bJ, BlockPistonRelay.getCoordsAsString(world.field_73011_w.field_76574_g, x, y, z));
            world.func_72908_a((double)x, (double)y, (double)z, "random.orb", 0.5f, 1.0f);
        } else {
            this.func_71929_a(world, x, y, z, new ItemStack((Block)this));
            world.func_94571_i(x, y, z);
            if (!world.field_72995_K) {
                world.func_72926_e(2001, x, y, z, this.field_71990_ca);
            }
        }
        return true;
    }

    @ForgeSubscribe
    public void onWorldLoad(WorldEvent.Load event) {
        WorldData.get(event.world);
    }

    @Override
    public LexiconEntry getEntry(World world, int x, int y, int z, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.pistonRelay;
    }

    public static class InternalTickHandler
    implements ITickHandler {
        public static Map<String, String> playerPositions = new HashMap<String, String>();
        public static Map<String, String> mappedPositions = new HashMap<String, String>();
        static List<String> removeThese = new ArrayList<String>();
        static Map<String, Integer> coordsToCheck = new HashMap<String, Integer>();

        public void tickStart(EnumSet<TickType> type, Object ... tickData) {
        }

        public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
            for (String s : coordsToCheck.keySet()) {
                int id = BlockPistonRelay.getBlockIDAt(s);
                BlockPistonRelay.decrCoords(s);
                if (id != 36) continue;
                int meta = BlockPistonRelay.getBlockMetaAt(s);
                ForgeDirection dir = ForgeDirection.getOrientation((int)(meta & 0xFFFFFFF7));
                MinecraftServer server = MinecraftServer.func_71276_C();
                if (server == null || BlockPistonRelay.getTimeInCoords(s) != 0) continue;
                String[] tokens = s.split(":");
                int worldId = Integer.parseInt(tokens[0]);
                int x = Integer.parseInt(tokens[1]);
                int y = Integer.parseInt(tokens[2]);
                int z = Integer.parseInt(tokens[3]);
                WorldServer world = server.func_71218_a(worldId);
                world.func_94575_c(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, ModBlocks.pistonRelay.field_71990_ca);
                String newPos = BlockPistonRelay.getCoordsAsString(world.field_73011_w.field_76574_g, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
                if (!mappedPositions.containsKey(s)) continue;
                String pos = mappedPositions.get(s);
                String[] tokens2 = pos.split(":");
                int worldId2 = Integer.parseInt(tokens2[0]);
                int x2 = Integer.parseInt(tokens2[1]);
                int y2 = Integer.parseInt(tokens2[2]);
                int z2 = Integer.parseInt(tokens2[3]);
                WorldServer world2 = server.func_71218_a(worldId2);
                int srcId = world2.func_72798_a(x2, y2, z2);
                int srcMeta = world2.func_72805_g(x2, y2, z2);
                TileEntity tile = world2.func_72796_p(x2, y2, z2);
                Material mat = world2.func_72803_f(x2, y2, z2);
                if (tile == null && mat.func_76227_m() == 0 && Block.field_71973_m[srcId] != null && !Block.field_71973_m[srcId].isAirBlock((World)world2, x2, y2, z2)) {
                    Material destMat = world2.func_72803_f(x2 + dir.offsetX, y2 + dir.offsetY, z2 + dir.offsetZ);
                    if (world2.func_72799_c(x2 + dir.offsetX, y2 + dir.offsetY, z2 + dir.offsetZ) || destMat.func_76222_j()) {
                        world2.func_94575_c(x2, y2, z2, 0);
                        world2.func_72832_d(x2 + dir.offsetX, y2 + dir.offsetY, z2 + dir.offsetZ, srcId, srcMeta, 3);
                        mappedPositions.put(s, BlockPistonRelay.getCoordsAsString(world2.field_73011_w.field_76574_g, x2 + dir.offsetX, y2 + dir.offsetY, z2 + dir.offsetZ));
                    }
                }
                pos = mappedPositions.get(s);
                mappedPositions.remove(s);
                mappedPositions.put(newPos, pos);
                WorldData.get((World)world2).func_76185_a();
            }
            for (String s : removeThese) {
                coordsToCheck.remove(s);
            }
            removeThese.clear();
        }

        public EnumSet<TickType> ticks() {
            return EnumSet.of(TickType.SERVER);
        }

        public String getLabel() {
            return "botania:pistonRelay";
        }
    }

    public static class WorldData
    extends WorldSavedData {
        private static final String ID = "PistonRelayPairs";

        public WorldData(String id) {
            super(id);
        }

        public void func_76184_a(NBTTagCompound nbttagcompound) {
            InternalTickHandler.mappedPositions.clear();
            Collection tags = nbttagcompound.func_74758_c();
            for (NBTBase tag : tags) {
                if (!(tag instanceof NBTTagString)) continue;
                String key = tag.func_74740_e();
                String value = ((NBTTagString)tag).field_74751_a;
                InternalTickHandler.mappedPositions.put(key, value);
            }
        }

        public void func_76187_b(NBTTagCompound nbttagcompound) {
            for (String s : InternalTickHandler.mappedPositions.keySet()) {
                nbttagcompound.func_74778_a(s, InternalTickHandler.mappedPositions.get(s));
            }
        }

        public static WorldData get(World world) {
            WorldData data = (WorldData)world.field_72988_C.func_75742_a(WorldData.class, ID);
            if (data == null) {
                data = new WorldData(ID);
                data.func_76185_a();
                world.field_72988_C.func_75745_a(ID, (WorldSavedData)data);
            }
            return data;
        }
    }
}

