/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import cpw.mods.fml.common.network.PacketDispatcher;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.common.block.tile.TileMod;

public class TileDistributor
extends TileMod
implements IManaReceiver {
    List<IManaReceiver> validPools = new ArrayList<IManaReceiver>();
    static final ForgeDirection[] DIRECTIONS = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST};

    public void func_70316_g() {
        this.validPools.clear();
        for (ForgeDirection dir : DIRECTIONS) {
            IManaReceiver receiver;
            TileEntity tileAt = this.field_70331_k.func_72796_p(this.field_70329_l + dir.offsetX, this.field_70330_m, this.field_70327_n + dir.offsetZ);
            if (tileAt == null || !(tileAt instanceof IManaPool) || (receiver = (IManaReceiver)tileAt).isFull()) continue;
            this.validPools.add(receiver);
        }
    }

    @Override
    public int getCurrentMana() {
        return 0;
    }

    @Override
    public boolean isFull() {
        return this.validPools.isEmpty();
    }

    @Override
    public void recieveMana(int mana) {
        int tiles = this.validPools.size();
        if (tiles != 0) {
            int manaForEach = mana / tiles;
            for (IManaReceiver pool : this.validPools) {
                pool.recieveMana(manaForEach);
                PacketDispatcher.sendPacketToAllInDimension((Packet)((TileEntity)pool).func_70319_e(), (int)this.field_70331_k.field_73011_w.field_76574_g);
            }
        }
    }

    @Override
    public boolean canRecieveManaFromBursts() {
        return !this.isFull();
    }
}

