/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.ManaNetworkEvent;
import vazkii.botania.api.recipe.RecipeManaInfusion;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileMod;

public class TilePool
extends TileMod
implements IManaPool {
    public static final int MAX_MANA = 1000000;
    private static final String TAG_MANA = "mana";
    private static final String TAG_KNOWN_MANA = "knownMana";
    private static final String TAG_OUTPUTTING = "outputting";
    boolean outputting = false;
    int mana;
    int knownMana = -1;
    boolean added = false;

    @Override
    public boolean isFull() {
        int idBelow = this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
        return idBelow != ModBlocks.manaVoid.field_71990_ca && this.mana >= 1000000;
    }

    @Override
    public void recieveMana(int mana) {
        boolean full = this.mana >= 1000000;
        this.mana = Math.min(this.mana + mana, 1000000);
        if (!full) {
            this.field_70331_k.func_96440_m(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
        }
    }

    public void func_70313_j() {
        super.func_70313_j();
        ManaNetworkEvent.removePool(this);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        ManaNetworkEvent.removePool(this);
    }

    public boolean collideEntityItem(EntityItem item) {
        boolean didChange = false;
        ItemStack stack = item.func_92059_d();
        if (stack == null) {
            return false;
        }
        for (RecipeManaInfusion recipe : BotaniaAPI.manaInfusionRecipes) {
            if (!recipe.matches(stack)) continue;
            int mana = recipe.getManaToConsume();
            if (this.getCurrentMana() < mana) break;
            this.recieveMana(-mana);
            if (!this.field_70331_k.field_72995_K) {
                --stack.field_77994_a;
                if (stack.field_77994_a == 0) {
                    item.func_70106_y();
                }
                ItemStack output = recipe.getOutput().func_77946_l();
                EntityItem outputItem = new EntityItem(this.field_70331_k, (double)this.field_70329_l + 0.5, (double)this.field_70330_m + 1.5, (double)this.field_70327_n + 0.5, output);
                this.field_70331_k.func_72838_d((Entity)outputItem);
            }
            this.craftingFanciness();
            didChange = true;
            break;
        }
        return didChange;
    }

    public void craftingFanciness() {
        this.field_70331_k.func_72908_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, "random.levelup", 1.0f, 1.0f);
        for (int i = 0; i < 25; ++i) {
            float red = (float)Math.random();
            float green = (float)Math.random();
            float blue = (float)Math.random();
            Botania.proxy.sparkleFX(this.field_70331_k, (double)this.field_70329_l + 0.5 + Math.random() * 0.4 - 0.2, this.field_70330_m + 1, (double)this.field_70327_n + 0.5 + Math.random() * 0.4 - 0.2, red, green, blue, (float)Math.random(), 10);
        }
    }

    public void func_70316_g() {
        if (!this.added) {
            ManaNetworkEvent.addPool(this);
            this.added = true;
        }
        if (this.field_70331_k.field_72995_K) {
            double particleChance = 1.0 - (double)this.getCurrentMana() / 1000000.0 * 0.1;
            Color color = new Color(50943);
            if (Math.random() > particleChance) {
                Botania.proxy.wispFX(this.field_70331_k, (double)this.field_70329_l + 0.3 + Math.random() * 0.5, (double)this.field_70330_m + 0.6 + Math.random() * 0.25, (double)this.field_70327_n + Math.random(), (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)Math.random() / 3.0f, (float)(-Math.random()) / 25.0f);
            }
        }
        List items = this.field_70331_k.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 1), (double)(this.field_70327_n + 1)));
        for (EntityItem item : items) {
            int manaVal;
            ItemStack stack = item.func_92059_d();
            if (stack == null || !(stack.func_77973_b() instanceof IManaItem)) continue;
            IManaItem mana = (IManaItem)stack.func_77973_b();
            if ((!this.outputting || !mana.canReceiveManaFromPool(stack, this)) && (this.outputting || !mana.canExportManaToPool(stack, this))) continue;
            boolean didSomething = false;
            if (this.outputting) {
                if (this.mana > 0) {
                    didSomething = true;
                }
                manaVal = Math.min(1000, Math.min(this.mana, mana.getMaxMana(stack) - mana.getMana(stack)));
                mana.addMana(stack, manaVal);
                this.recieveMana(-manaVal);
            } else {
                if (mana.getMana(stack) > 0) {
                    didSomething = true;
                }
                manaVal = Math.min(1000, Math.min(1000000 - this.mana, mana.getMana(stack)));
                mana.addMana(stack, -manaVal);
                this.recieveMana(manaVal);
            }
            if (!didSomething) continue;
            PacketDispatcher.sendPacketToAllInDimension((Packet)this.func_70319_e(), (int)this.field_70331_k.field_73011_w.field_76574_g);
            if (!this.field_70331_k.field_72995_K) continue;
            Color color = new Color(50943);
            Botania.proxy.wispFX(this.field_70331_k, item.field_70165_t + Math.random() * 0.5 - 0.25, item.field_70163_u + Math.random() * 0.5 - (this.outputting ? 0.65 : 0.25), item.field_70161_v + Math.random() * 0.5 - 0.25, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)Math.random() / 15.0f, (this.outputting ? -1.0f : 1.0f) * (float)Math.random() / 25.0f);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_MANA, this.mana);
        cmp.func_74757_a(TAG_OUTPUTTING, this.outputting);
    }

    @Override
    public void readCustomNBT(NBTTagCompound cmp) {
        this.mana = cmp.func_74762_e(TAG_MANA);
        this.outputting = cmp.func_74767_n(TAG_OUTPUTTING);
        if (cmp.func_74764_b(TAG_KNOWN_MANA)) {
            this.knownMana = cmp.func_74762_e(TAG_KNOWN_MANA);
        }
    }

    public void onWanded(EntityPlayer player, ItemStack wand) {
        if (player.func_70093_af()) {
            this.outputting = !this.outputting;
            PacketDispatcher.sendPacketToAllInDimension((Packet)this.func_70319_e(), (int)this.field_70331_k.field_73011_w.field_76574_g);
        }
        if (!this.field_70331_k.field_72995_K) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            this.writeCustomNBT(nbttagcompound);
            nbttagcompound.func_74768_a(TAG_KNOWN_MANA, this.getCurrentMana());
            PacketDispatcher.sendPacketToPlayer((Packet)new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, -999, nbttagcompound), (Player)((Player)player));
        }
        this.field_70331_k.func_72956_a((Entity)player, "random.orb", 0.11f, 1.0f);
    }

    public void renderHUD(Minecraft mc, ScaledResolution res) {
        String name = ModBlocks.pool.func_71931_t();
        int color = 0x660000FF;
        HUDHandler.drawSimpleManaHUD(color, this.knownMana, 1000000, name, res);
        String power = StatCollector.func_74838_a((String)("botaniamisc." + (this.outputting ? "outputtingPower" : "inputtingPower")));
        int x = res.func_78326_a() / 2 - mc.field_71466_p.func_78256_a(power) / 2;
        int y = res.func_78328_b() / 2 + 30;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        mc.field_71466_p.func_78261_a(power, x, y, color);
        GL11.glDisable((int)3042);
    }

    @Override
    public boolean canRecieveManaFromBursts() {
        return true;
    }

    @Override
    public boolean isOutputtingPower() {
        return this.outputting;
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }
}

