/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import java.io.File;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import vazkii.botania.common.lib.LibBlockIDs;
import vazkii.botania.common.lib.LibItemIDs;

public final class ConfigHandler {
    private static Configuration config;
    public static boolean lexiconRotatingItems;
    public static boolean subtlePowerSystem;
    public static boolean staticWandBeam;
    public static boolean overrideVanillaBlocks;
    public static boolean boundBlockWireframe;
    public static boolean lexicon3dModel;
    public static int flowerQuantity;
    public static int flowerDensity;

    public static void loadConfig(File configFile) {
        config = new Configuration(configFile);
        config.load();
        Property lexiconRotatingItemsProp = config.get("general", "lexicon.enable.rotatingItems", true);
        lexiconRotatingItemsProp.comment = "Set to false to disable the rotating items in the petal and rune entries in the Lexica Botania.";
        lexiconRotatingItems = lexiconRotatingItemsProp.getBoolean(true);
        Property subtlePowerSystemProp = config.get("general", "powerSystem.subtle", false);
        subtlePowerSystemProp.comment = "Set to true to set the power system's particles to be a lot more subtle. Good for low-end systems, if the particles are causing lag.";
        subtlePowerSystem = subtlePowerSystemProp.getBoolean(false);
        Property staticWandBeamProp = config.get("general", "wandBeam.static", false);
        staticWandBeamProp.comment = "Set to true to use a static wand beam that shows every single position of the burst, similar to the way it used to work on old botania versions. Warning: Disabled by default because it may be laggy.";
        staticWandBeam = staticWandBeamProp.getBoolean(false);
        Property overrideVanillaBlocksProp = config.get("general", "override.vanillaBlocks", true);
        overrideVanillaBlocksProp.comment = "Set to false to remove the overriding of vanilla blocks (snow, red and yellow flowers). Setting this to false will remove the snow on flowers tweak.";
        overrideVanillaBlocks = overrideVanillaBlocksProp.getBoolean(true);
        Property boundBlockWireframeProp = config.get("general", "boundBlock.wireframe.enabled", true);
        boundBlockWireframeProp.comment = "Set to false to disable the wireframe when looking a block bound to something (spreaders, flowers, etc).";
        boundBlockWireframe = boundBlockWireframeProp.getBoolean(true);
        Property lexicon3dModelProp = config.get("general", "lexicon.render.3D", true);
        lexicon3dModelProp.comment = "Set to false to disabled the animated 3D render for the lexica botania";
        lexicon3dModel = lexicon3dModelProp.getBoolean(true);
        Property propFlowerQuantity = config.get("general", "worldgen.flower.quantity", 3);
        flowerQuantity = propFlowerQuantity.getInt(3);
        Property propFlowerDensity = config.get("general", "worldgen.flower.density", 32);
        flowerDensity = propFlowerDensity.getInt(32);
        LibBlockIDs.idFlower = ConfigHandler.loadBlock("botania:flower", LibBlockIDs.idFlower);
        LibBlockIDs.idAltar = ConfigHandler.loadBlock("botania:altar", LibBlockIDs.idAltar);
        LibBlockIDs.idSpecialFlower = ConfigHandler.loadBlock("botania:specialFlower", LibBlockIDs.idSpecialFlower);
        LibBlockIDs.idLivingrock = ConfigHandler.loadBlock("botania:livingrock", LibBlockIDs.idLivingrock);
        LibBlockIDs.idLivingwood = ConfigHandler.loadBlock("botania:livingwood", LibBlockIDs.idLivingwood);
        LibBlockIDs.idSpreader = ConfigHandler.loadBlock("botania:spreader", LibBlockIDs.idSpreader);
        LibBlockIDs.idPool = ConfigHandler.loadBlock("botania:pool", LibBlockIDs.idPool);
        LibBlockIDs.idRuneAltar = ConfigHandler.loadBlock("botania:runeAltar", LibBlockIDs.idRuneAltar);
        LibBlockIDs.idUnstableBlock = ConfigHandler.loadBlock("botania:unstableBlock", LibBlockIDs.idUnstableBlock);
        LibBlockIDs.idPylon = ConfigHandler.loadBlock("botania:pylon", LibBlockIDs.idPylon);
        LibBlockIDs.idPistonRelay = ConfigHandler.loadBlock("botania:pistonRelay", LibBlockIDs.idPistonRelay);
        LibBlockIDs.idDistributor = ConfigHandler.loadBlock("botania:distributor", LibBlockIDs.idDistributor);
        LibBlockIDs.idManaBeacon = ConfigHandler.loadBlock("botania:manaBeacon", LibBlockIDs.idManaBeacon);
        LibBlockIDs.idManaVoid = ConfigHandler.loadBlock("botania:manaVoid", LibBlockIDs.idManaVoid);
        LibBlockIDs.idManaDetector = ConfigHandler.loadBlock("botania:manaDetector", LibBlockIDs.idManaDetector);
        LibBlockIDs.idEnchanter = ConfigHandler.loadBlock("botania:enchanter", LibBlockIDs.idEnchanter);
        LibBlockIDs.idTurntable = ConfigHandler.loadBlock("botania:turntable", LibBlockIDs.idTurntable);
        LibItemIDs.idLexicon = ConfigHandler.loadItem("botania:lexicon", LibItemIDs.idLexicon);
        LibItemIDs.idPetal = ConfigHandler.loadItem("botania:petal", LibItemIDs.idPetal);
        LibItemIDs.idDye = ConfigHandler.loadItem("botania:dye", LibItemIDs.idDye);
        LibItemIDs.idPestleAndMortar = ConfigHandler.loadItem("botania:pestleAndMortar", LibItemIDs.idPestleAndMortar);
        LibItemIDs.idTwigWand = ConfigHandler.loadItem("botania:twigWand", LibItemIDs.idTwigWand);
        LibItemIDs.idManaResource = ConfigHandler.loadItem("botania:manaResource", LibItemIDs.idManaResource);
        LibItemIDs.idLens = ConfigHandler.loadItem("botania:lens", LibItemIDs.idLens);
        LibItemIDs.idManaPetal = ConfigHandler.loadItem("botania:manaPetal", LibItemIDs.idManaPetal);
        LibItemIDs.idRune = ConfigHandler.loadItem("botania:rune", LibItemIDs.idRune);
        LibItemIDs.idSignalFlare = ConfigHandler.loadItem("botania:signalFlare", LibItemIDs.idSignalFlare);
        LibItemIDs.idManaTablet = ConfigHandler.loadItem("botania:manaTablet", LibItemIDs.idManaTablet);
        LibItemIDs.idManaGun = ConfigHandler.loadItem("botania:manaGun", LibItemIDs.idManaGun);
        LibItemIDs.idManaCookie = ConfigHandler.loadItem("botania:manaCookie", LibItemIDs.idManaCookie);
        config.save();
    }

    private static int loadItem(String label, int defaultID) {
        return config.getItem(label, defaultID).getInt(defaultID);
    }

    private static int loadBlock(String label, int defaultID) {
        return config.getBlock(label, defaultID).getInt(defaultID);
    }

    static {
        lexiconRotatingItems = true;
        subtlePowerSystem = false;
        staticWandBeam = false;
        overrideVanillaBlocks = true;
        boundBlockWireframe = true;
        lexicon3dModel = true;
        flowerQuantity = 3;
        flowerDensity = 32;
    }
}

