/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.event.ForgeSubscribe;
import vazkii.botania.api.internal.IManaNetwork;
import vazkii.botania.api.mana.ManaNetworkEvent;
import vazkii.botania.common.core.helper.MathHelper;

public final class ManaNetworkHandler
implements IManaNetwork {
    public static final ManaNetworkHandler instance = new ManaNetworkHandler();
    public Map<Integer, List<TileEntity>> manaPools = new HashMap<Integer, List<TileEntity>>();
    public Map<Integer, List<TileEntity>> manaCollectors = new HashMap<Integer, List<TileEntity>>();

    @ForgeSubscribe
    public void onNetworkEvent(ManaNetworkEvent event) {
        Map<Integer, List<TileEntity>> map;
        Map<Integer, List<TileEntity>> map2 = map = event.type == ManaNetworkEvent.ManaBlockType.COLLECTOR ? this.manaCollectors : this.manaPools;
        if (event.action == ManaNetworkEvent.Action.ADD) {
            this.add(map, event.tile);
        } else {
            this.remove(map, event.tile);
        }
    }

    @Override
    public void clear() {
        this.manaPools.clear();
        this.manaCollectors.clear();
    }

    @Override
    public TileEntity getClosestPool(ChunkCoordinates pos, int dimension, int limit) {
        if (this.manaPools.containsKey(dimension)) {
            return this.getClosest(this.manaPools.get(dimension), pos, limit);
        }
        return null;
    }

    @Override
    public TileEntity getClosestCollector(ChunkCoordinates pos, int dimension, int limit) {
        if (this.manaCollectors.containsKey(dimension)) {
            return this.getClosest(this.manaCollectors.get(dimension), pos, limit);
        }
        return null;
    }

    private synchronized TileEntity getClosest(List<TileEntity> tiles, ChunkCoordinates pos, int limit) {
        float closest = Float.MAX_VALUE;
        TileEntity closestTile = null;
        for (TileEntity tile : tiles) {
            float distance = MathHelper.pointDistanceSpace(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n, pos.field_71574_a, pos.field_71572_b, pos.field_71573_c);
            if (distance > (float)limit || !(distance < closest)) continue;
            closest = distance;
            closestTile = tile;
        }
        return closestTile;
    }

    private synchronized void remove(Map<Integer, List<TileEntity>> map, TileEntity tile) {
        int dim = tile.field_70331_k.field_73011_w.field_76574_g;
        if (!map.containsKey(dim)) {
            return;
        }
        List<TileEntity> tiles = map.get(dim);
        tiles.remove(tile);
    }

    private synchronized void add(Map<Integer, List<TileEntity>> map, TileEntity tile) {
        List<TileEntity> tiles;
        int dim = tile.field_70331_k.field_73011_w.field_76574_g;
        if (!map.containsKey(dim)) {
            map.put(dim, new ArrayList());
        }
        if (!(tiles = map.get(dim)).contains(tile)) {
            tiles.add(tile);
        }
    }

    @Override
    public List<TileEntity> getAllCollectorsInWorld(int dim) {
        return this.getAllInWorld(this.manaCollectors, dim);
    }

    @Override
    public List<TileEntity> getAllPoolsInWorld(int dim) {
        return this.getAllInWorld(this.manaPools, dim);
    }

    private List<TileEntity> getAllInWorld(Map<Integer, List<TileEntity>> map, int dim) {
        if (!map.containsKey(dim)) {
            return new ArrayList<TileEntity>();
        }
        return map.get(dim);
    }
}

