/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import cpw.mods.fml.common.registry.GameRegistry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.crafting.recipe.CompositeLensRecipe;
import vazkii.botania.common.item.ItemMod;
import vazkii.botania.common.lib.LibItemIDs;
import vazkii.botania.common.lib.LibItemNames;

public class ItemLens
extends ItemMod
implements ILens {
    private static final int NORMAL = 0;
    private static final int SPEED = 1;
    private static final int POWER = 2;
    private static final int TIME = 3;
    private static final int EFFICIENCY = 4;
    private static final int BOUNCE = 5;
    private static final int GRAVITY = 6;
    private static final int MINE = 7;
    private static final int DAMAGE = 8;
    private static final int PHANTOM = 9;
    private static final int MAGNET = 10;
    private static final int EXPLOSIVE = 11;
    private static final Map<Integer, List<Integer>> blacklist = new HashMap<Integer, List<Integer>>();
    private static final String TAG_COLOR = "color";
    private static final String TAG_COMPOSITE_LENS = "compositeLens";
    public static Icon iconGlass;
    public static final int SUBTYPES = 12;
    Icon[] ringIcons;

    public ItemLens() {
        super(LibItemIDs.idLens);
        this.func_77655_b("botania:lens");
        this.func_77625_d(1);
        this.func_77627_a(true);
        GameRegistry.addRecipe((IRecipe)new CompositeLensRecipe());
    }

    @Override
    public void func_94581_a(IconRegister par1IconRegister) {
        iconGlass = IconHelper.forName(par1IconRegister, "lensInside");
        this.ringIcons = new Icon[12];
        for (int i = 0; i < this.ringIcons.length; ++i) {
            this.ringIcons[i] = IconHelper.forNameRaw(par1IconRegister, LibItemNames.LENS_NAMES[i]);
        }
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < 12; ++i) {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }

    public boolean func_77623_v() {
        return true;
    }

    public Icon func_77618_c(int par1, int par2) {
        return par2 == 0 ? this.ringIcons[Math.min(11, par1)] : iconGlass;
    }

    public Icon func_77617_a(int par1) {
        return this.func_77618_c(par1, 0);
    }

    public int func_82790_a(ItemStack par1ItemStack, int par2) {
        return par2 == 1 ? this.getLensColor(par1ItemStack) : 0xFFFFFF;
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        return "item." + LibItemNames.LENS_NAMES[Math.min(11, par1ItemStack.func_77960_j())];
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        int storedColor = ItemLens.getStoredColor(par1ItemStack);
        if (storedColor != -1) {
            par3List.add(String.format(StatCollector.func_74838_a((String)"botaniamisc.color"), StatCollector.func_74838_a((String)("botania.color" + storedColor))));
        }
    }

    public String getItemShortTermName(ItemStack stack) {
        return StatCollector.func_74838_a((String)(stack.func_77977_a() + ".short"));
    }

    public String func_77628_j(ItemStack stack) {
        ItemStack compositeLens = this.getCompositeLens(stack);
        if (compositeLens == null) {
            return super.func_77628_j(stack);
        }
        return String.format(StatCollector.func_74838_a((String)"item.botania:compositeLens.name"), this.getItemShortTermName(stack), this.getItemShortTermName(compositeLens));
    }

    @Override
    public void apply(ItemStack stack, BurstProperties props) {
        int storedColor = ItemLens.getStoredColor(stack);
        if (storedColor != -1) {
            props.color = this.getLensColor(stack);
        }
        switch (stack.func_77960_j()) {
            case 1: {
                props.motionModifier *= 2.0f;
                props.maxMana = (int)((float)props.maxMana * 0.75f);
                props.ticksBeforeManaLoss = (int)((float)props.ticksBeforeManaLoss / 3.0f);
                props.manaLossPerTick *= 2.0f;
                break;
            }
            case 2: {
                props.maxMana *= 2;
                props.motionModifier *= 0.85f;
                props.manaLossPerTick *= 2.0f;
                break;
            }
            case 3: {
                props.ticksBeforeManaLoss = (int)((float)props.ticksBeforeManaLoss * 2.25f);
                props.motionModifier *= 0.8f;
                break;
            }
            case 4: {
                props.manaLossPerTick /= 5.0f;
                props.ticksBeforeManaLoss = (int)((float)props.ticksBeforeManaLoss * 1.1f);
                break;
            }
            case 6: {
                props.gravity = 0.0015f;
                props.ticksBeforeManaLoss = (int)((float)props.ticksBeforeManaLoss * 1.2f);
            }
        }
        ItemStack compositeLens = this.getCompositeLens(stack);
        if (compositeLens != null && compositeLens.func_77973_b() instanceof ILens) {
            ((ILens)compositeLens.func_77973_b()).apply(compositeLens, props);
        }
    }

    @Override
    public boolean collideBurst(IManaBurst burst, MovingObjectPosition pos, boolean isManaBlock, boolean dead, ItemStack stack) {
        EntityThrowable entity = (EntityThrowable)burst;
        switch (stack.func_77960_j()) {
            case 5: {
                if (isManaBlock || pos.field_72308_g != null) break;
                ChunkCoordinates coords = burst.getBurstSourceChunkCoordinates();
                if (coords.field_71574_a == pos.field_72311_b && coords.field_71572_b == pos.field_72312_c && coords.field_71573_c == pos.field_72309_d) break;
                Vector3 currentMovementVec = new Vector3(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
                ForgeDirection dir = ForgeDirection.getOrientation((int)pos.field_72310_e);
                Vector3 normalVector = new Vector3(dir.offsetX, dir.offsetY, dir.offsetZ).normalize();
                Vector3 movementVec = normalVector.multiply(-2.0 * currentMovementVec.dotProduct(normalVector)).add(currentMovementVec);
                burst.setMotion(movementVec.x, movementVec.y, movementVec.z);
                dead = false;
                break;
            }
            case 7: {
                World world = entity.field_70170_p;
                int x = pos.field_72311_b;
                int y = pos.field_72312_c;
                int z = pos.field_72309_d;
                int id = world.func_72798_a(x, y, z);
                int meta = world.func_72805_g(x, y, z);
                Block block = Block.field_71973_m[id];
                float hardness = block.func_71934_m(world, x, y, z);
                int mana = burst.getMana();
                ChunkCoordinates coords = burst.getBurstSourceChunkCoordinates();
                if (coords.field_71574_a == x && coords.field_71572_b == y && coords.field_71573_c == z || isManaBlock || block == null || hardness == -1.0f || !(hardness < 50.0f) || !burst.isFake() && mana < 24) break;
                ArrayList items = new ArrayList();
                items.addAll(block.getBlockDropped(world, x, y, z, meta, 0));
                if (!(burst.hasAlreadyCollidedAt(x, y, z) || burst.isFake() || entity.field_70170_p.field_72995_K)) {
                    world.func_94571_i(x, y, z);
                    entity.field_70170_p.func_72926_e(2001, x, y, z, id + (meta << 12));
                    for (ItemStack stack_ : items) {
                        world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack_));
                    }
                    burst.setMana(mana - 24);
                }
                dead = false;
                break;
            }
            case 8: {
                if (pos.field_72308_g != null && pos.field_72308_g instanceof EntityLivingBase) {
                    int mana;
                    EntityLivingBase living = (EntityLivingBase)pos.field_72308_g;
                    if (living.field_70737_aN == 0 && (mana = burst.getMana()) >= 16) {
                        burst.setMana(mana - 16);
                        if (!burst.isFake() && !entity.field_70170_p.field_72995_K) {
                            living.func_70097_a(DamageSource.field_76376_m, 2.0f);
                        }
                    }
                }
            }
            case 9: {
                if (isManaBlock) break;
                dead = false;
                burst.setMinManaLoss(Math.max(0, burst.getMinManaLoss() - 4));
                break;
            }
            case 11: {
                ChunkCoordinates coords;
                if (!burst.isFake()) {
                    coords = burst.getBurstSourceChunkCoordinates();
                    if (entity.field_70170_p.field_72995_K || pos.field_72308_g != null || isManaBlock || pos.field_72311_b == coords.field_71574_a && pos.field_72312_c == coords.field_71572_b && pos.field_72309_d == coords.field_71573_c) break;
                    entity.field_70170_p.func_72876_a((Entity)entity, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (float)burst.getMana() / 50.0f, true);
                    break;
                }
                dead = false;
            }
        }
        ItemStack compositeLens = this.getCompositeLens(stack);
        if (compositeLens != null && compositeLens.func_77973_b() instanceof ILens) {
            dead = ((ILens)compositeLens.func_77973_b()).collideBurst(burst, pos, isManaBlock, dead, compositeLens);
        }
        return dead;
    }

    @Override
    public void updateBurst(IManaBurst burst, ItemStack stack) {
        int storedColor = ItemLens.getStoredColor(stack);
        if (storedColor == 16) {
            burst.setColor(this.getLensColor(stack));
        }
        EntityThrowable entity = (EntityThrowable)burst;
        boolean magnetized = entity.getEntityData().func_74764_b("Botania:Magnetized");
        block0 : switch (stack.func_77960_j()) {
            case 10: {
                int x = (int)entity.field_70165_t;
                int y = (int)entity.field_70163_u;
                int z = (int)entity.field_70161_v;
                int range = 3;
                for (int i = -range; i < range; ++i) {
                    for (int j = -range; j < range; ++j) {
                        for (int k = -range; k < range; ++k) {
                            if (!(entity.field_70170_p.func_72796_p(i + x, j + y, k + z) instanceof IManaReceiver)) continue;
                            TileEntity tile = entity.field_70170_p.func_72796_p(i + x, j + y, k + z);
                            if (magnetized) {
                                int magX = entity.getEntityData().func_74762_e("Botania:MagnetizedX");
                                int magY = entity.getEntityData().func_74762_e("Botania:MagnetizedY");
                                int magZ = entity.getEntityData().func_74762_e("Botania:MagnetizedZ");
                                if (tile.field_70329_l != magX || tile.field_70330_m != magY || tile.field_70327_n != magZ) continue;
                            }
                            IManaReceiver receiver = (IManaReceiver)tile;
                            ChunkCoordinates srcCoords = burst.getBurstSourceChunkCoordinates();
                            if (!(MathHelper.pointDistanceSpace(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n, srcCoords.field_71574_a, srcCoords.field_71572_b, srcCoords.field_71573_c) > 3.0f) || !receiver.canRecieveManaFromBursts() || receiver.isFull()) continue;
                            Vector3 burstVec = Vector3.fromEntity((Entity)entity);
                            Vector3 tileVec = Vector3.fromTileEntityCenter(tile).add(0.0, -0.1, 0.0);
                            Vector3 motionVec = new Vector3(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
                            Vector3 normalMotionVec = motionVec.copy().normalize();
                            Vector3 magnetVec = tileVec.sub(burstVec).normalize();
                            Vector3 differenceVec = normalMotionVec.sub(magnetVec).multiply(motionVec.mag() * 0.1);
                            Vector3 finalMotionVec = motionVec.sub(differenceVec);
                            if (!magnetized) {
                                finalMotionVec.multiply(0.75);
                                entity.getEntityData().func_74757_a("Botania:Magnetized", true);
                                entity.getEntityData().func_74768_a("Botania:MagnetizedX", tile.field_70329_l);
                                entity.getEntityData().func_74768_a("Botania:MagnetizedY", tile.field_70330_m);
                                entity.getEntityData().func_74768_a("Botania:MagnetizedZ", tile.field_70327_n);
                            }
                            burst.setMotion(finalMotionVec.x, finalMotionVec.y, finalMotionVec.z);
                            break block0;
                        }
                    }
                }
                break;
            }
        }
        ItemStack compositeLens = this.getCompositeLens(stack);
        if (compositeLens != null && compositeLens.func_77973_b() instanceof ILens) {
            ((ILens)compositeLens.func_77973_b()).updateBurst(burst, compositeLens);
        }
    }

    @Override
    public int getLensColor(ItemStack stack) {
        int storedColor = ItemLens.getStoredColor(stack);
        if (storedColor == -1) {
            return 0xFFFFFF;
        }
        if (storedColor == 16) {
            return Color.HSBtoRGB((float)(Botania.proxy.getWorldElapsedTicks() * 2L % 360L) / 360.0f, 1.0f, 1.0f);
        }
        float[] color = EntitySheep.field_70898_d[storedColor];
        return new Color(color[0], color[1], color[2]).getRGB();
    }

    public static int getStoredColor(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_COLOR, -1);
    }

    public static ItemStack setLensColor(ItemStack stack, int color) {
        ItemNBTHelper.setInt(stack, TAG_COLOR, color);
        return stack;
    }

    @Override
    public boolean doParticles(IManaBurst burst, ItemStack stack) {
        int storedColor = ItemLens.getStoredColor(stack);
        if (storedColor == 16 && !burst.isFake()) {
            return ((EntityThrowable)burst).field_70173_aa > 5;
        }
        return true;
    }

    public static void blacklistLenses(int lens1, int lens2) {
        ItemLens.blacklistLenses(lens1, lens2, true);
    }

    public static void blacklistLenses(int lens1, int lens2, boolean recursive) {
        if (!blacklist.containsKey(lens1)) {
            blacklist.put(lens1, new ArrayList());
        }
        blacklist.get(lens1).add(lens2);
        if (recursive) {
            ItemLens.blacklistLenses(lens2, lens1, false);
        }
    }

    public static boolean isBlacklisted(int lens1, int lens2) {
        if (!blacklist.containsKey(lens1)) {
            return false;
        }
        return blacklist.get(lens1).contains(lens2);
    }

    @Override
    public boolean canCombineLenses(ItemStack sourceLens, ItemStack compositeLens) {
        if (sourceLens.func_77960_j() == compositeLens.func_77960_j()) {
            return false;
        }
        if (sourceLens.func_77960_j() == 0 || compositeLens.func_77960_j() == 0) {
            return false;
        }
        return !ItemLens.isBlacklisted(sourceLens.func_77960_j(), compositeLens.func_77960_j());
    }

    @Override
    public ItemStack getCompositeLens(ItemStack stack) {
        NBTTagCompound cmp = ItemNBTHelper.getCompound(stack, TAG_COMPOSITE_LENS, false);
        ItemStack lens = ItemStack.func_77949_a((NBTTagCompound)cmp);
        return lens;
    }

    @Override
    public ItemStack setCompositeLens(ItemStack sourceLens, ItemStack compositeLens) {
        NBTTagCompound cmp = new NBTTagCompound();
        compositeLens.func_77955_b(cmp);
        ItemNBTHelper.setCompound(sourceLens, TAG_COMPOSITE_LENS, cmp);
        return sourceLens;
    }

    static {
        ItemLens.blacklistLenses(2, 11);
        ItemLens.blacklistLenses(6, 10);
        ItemLens.blacklistLenses(9, 7);
        ItemLens.blacklistLenses(9, 11);
        ItemLens.blacklistLenses(9, 5);
    }
}

