/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.SubTileEntity;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.lexicon.LexiconData;

public class SubTilePureDaisy
extends SubTileEntity {
    private static final String TAG_POSITION = "position";
    private static final String TAG_TICKS_REMAINING = "ticksRemaining";
    private static final int[][] POSITIONS = new int[][]{{-1, 0, -1}, {-1, 0, 0}, {-1, 0, 1}, {0, 0, 1}, {1, 0, 1}, {1, 0, 0}, {1, 0, -1}, {0, 0, -1}};
    int positionAt = 0;
    int[] ticksRemaining = new int[]{200, 200, 200, 200, 200, 200, 200, 200};

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void onUpdate() {
        Item item;
        ++this.positionAt;
        if (this.positionAt == POSITIONS.length) {
            this.positionAt = 0;
        }
        int[] acoords = POSITIONS[this.positionAt];
        ChunkCoordinates coords = new ChunkCoordinates(this.supertile.field_145851_c + acoords[0], this.supertile.field_145848_d + acoords[1], this.supertile.field_145849_e + acoords[2]);
        Block block = this.supertile.func_145831_w().func_147439_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
        if (block != Blocks.field_150350_a && (item = Item.func_150898_a((Block)block)) != null) {
            Block output;
            ItemStack stack = new ItemStack(item, 1, this.supertile.func_145831_w().func_72805_g(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c));
            Object object = this.isOreDict(stack, "stone") ? ModBlocks.livingrock : (output = this.isOreDict(stack, "logWood") ? ModBlocks.livingwood : null);
            if (output != null) {
                this.ticksRemaining[this.positionAt] = this.ticksRemaining[this.positionAt] - 1;
                Botania.proxy.sparkleFX(this.supertile.func_145831_w(), (double)coords.field_71574_a + Math.random(), (double)coords.field_71572_b + Math.random(), (double)coords.field_71573_c + Math.random(), 1.0f, 1.0f, 1.0f, (float)Math.random(), 5);
                if (this.ticksRemaining[this.positionAt] <= 0) {
                    this.supertile.func_145831_w().func_147449_b(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, output);
                    this.ticksRemaining[this.positionAt] = 200;
                    for (int i = 0; i < 25; ++i) {
                        double x = (double)coords.field_71574_a + Math.random();
                        double y = (double)coords.field_71572_b + Math.random() + 0.5;
                        double z = (double)coords.field_71573_c + Math.random();
                        Botania.proxy.wispFX(this.supertile.func_145831_w(), x, y, z, 1.0f, 1.0f, 1.0f, (float)Math.random() / 2.0f);
                    }
                    if (ConfigHandler.blockBreakParticles) {
                        this.supertile.func_145831_w().func_72926_e(2001, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, Block.func_149682_b((Block)block) + (this.supertile.func_145831_w().func_72805_g(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c) << 12));
                    }
                }
            } else {
                this.ticksRemaining[this.positionAt] = 200;
            }
        }
    }

    private boolean isOreDict(ItemStack stack, String entry) {
        for (ItemStack ostack : OreDictionary.getOres((String)entry)) {
            ItemStack cstack = ostack.func_77946_l();
            if (cstack.func_77960_j() == Short.MAX_VALUE) {
                cstack.func_77964_b(stack.func_77960_j());
            }
            if (!stack.func_77969_a(cstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound cmp) {
        this.positionAt = cmp.func_74762_e(TAG_POSITION);
        if (this.supertile.func_145831_w() != null && !this.supertile.func_145831_w().field_72995_K) {
            for (int i = 0; i < this.ticksRemaining.length; ++i) {
                this.ticksRemaining[i] = cmp.func_74762_e(TAG_TICKS_REMAINING + i);
            }
        }
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_POSITION, this.positionAt);
        for (int i = 0; i < this.ticksRemaining.length; ++i) {
            cmp.func_74768_a(TAG_TICKS_REMAINING + i, this.ticksRemaining[i]);
        }
    }

    @Override
    public LexiconEntry getEntry() {
        return LexiconData.pureDaisy;
    }
}

