/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.SubTileFunctional;
import vazkii.botania.common.core.helper.InventoryHelper;
import vazkii.botania.common.lexicon.LexiconData;
import vazkii.botania.common.lib.LibMisc;

public class SubTileHopperhock
extends SubTileFunctional {
    private static final String TAG_FILTER_TYPE = "filterType";
    int filterType = 0;

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.redstoneSignal > 0) {
            return;
        }
        boolean pulledAny = false;
        int range = this.mana > 0 ? 10 : 6;
        int x = this.supertile.field_145851_c;
        int y = this.supertile.field_145848_d;
        int z = this.supertile.field_145849_e;
        List items = this.supertile.func_145831_w().func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(x - range), (double)(y - range), (double)(z - range), (double)(x + range + 1), (double)(y + range), (double)(z + range + 1)));
        for (EntityItem item : items) {
            if (item.field_70292_b < 60 || item.field_70128_L) continue;
            ItemStack stack = item.func_92059_d();
            IInventory invToPutItemIn = null;
            ForgeDirection sideToPutItemIn = ForgeDirection.UNKNOWN;
            boolean priorityInv = false;
            for (ForgeDirection dir : LibMisc.CARDINAL_DIRECTIONS) {
                boolean priority;
                int x_ = x + dir.offsetX;
                int y_ = y + dir.offsetY;
                int z_ = z + dir.offsetZ;
                IInventory inv = InventoryHelper.getInventory(this.supertile.func_145831_w(), x_, y_, z_);
                if (inv == null) continue;
                List<ItemStack> filter = this.getFilterForInventory(inv, x_, y_, z_, true);
                boolean canAccept = this.canAcceptItem(stack, filter, this.filterType);
                int stackSize = InventoryHelper.testInventoryInsertion(inv, stack, dir);
                if (!(canAccept &= stackSize == stack.field_77994_a)) continue;
                boolean bl = priority = !filter.isEmpty();
                if (priorityInv && !priority) continue;
                invToPutItemIn = inv;
                priorityInv = priority;
                sideToPutItemIn = dir.getOpposite();
            }
            if (invToPutItemIn == null) continue;
            InventoryHelper.insertItemIntoInventory(invToPutItemIn, stack.func_77946_l(), sideToPutItemIn, -1);
            if (!this.supertile.func_145831_w().field_72995_K) {
                item.func_70106_y();
            }
            pulledAny = true;
            break;
        }
        if (pulledAny && this.mana > 1) {
            --this.mana;
        }
    }

    public boolean canAcceptItem(ItemStack stack, List<ItemStack> filter, int filterType) {
        if (stack == null) {
            return false;
        }
        if (filter.isEmpty()) {
            return true;
        }
        switch (filterType) {
            case 0: {
                boolean anyFilter = false;
                for (ItemStack filterEntry : filter) {
                    if (filterEntry == null) continue;
                    anyFilter = true;
                    if (!stack.func_77969_a(filterEntry) || !ItemStack.func_77970_a((ItemStack)filterEntry, (ItemStack)stack)) continue;
                    return true;
                }
                return !anyFilter;
            }
            case 1: {
                return !this.canAcceptItem(stack, filter, 0);
            }
        }
        return true;
    }

    public List<ItemStack> getFilterForInventory(IInventory inv, int x, int y, int z, boolean recursiveForDoubleChests) {
        ArrayList<ItemStack> filter = new ArrayList<ItemStack>();
        if (recursiveForDoubleChests) {
            TileEntity tileEntity = this.supertile.func_145831_w().func_147438_o(x, y, z);
            Block chest = this.supertile.func_145831_w().func_147439_a(x, y, z);
            if (tileEntity instanceof TileEntityChest) {
                for (ForgeDirection dir : LibMisc.CARDINAL_DIRECTIONS) {
                    if (this.supertile.func_145831_w().func_147439_a(x + dir.offsetX, y, z + dir.offsetZ) != chest) continue;
                    filter.addAll(this.getFilterForInventory((IInventory)this.supertile.func_145831_w().func_147438_o(x + dir.offsetX, y, z + dir.offsetZ), x + dir.offsetX, y, z + dir.offsetZ, false));
                    break;
                }
            }
        }
        int[] orientationToDir = new int[]{3, 4, 2, 5};
        for (ForgeDirection dir : LibMisc.CARDINAL_DIRECTIONS) {
            List frames = this.supertile.func_145831_w().func_72872_a(EntityItemFrame.class, AxisAlignedBB.func_72330_a((double)(x + dir.offsetX), (double)(y + dir.offsetY), (double)(z + dir.offsetZ), (double)(x + dir.offsetX + 1), (double)(y + dir.offsetY + 1), (double)(z + dir.offsetZ + 1)));
            for (EntityItemFrame frame : frames) {
                int orientation = frame.field_82332_a;
                if (orientationToDir[orientation] != dir.ordinal()) continue;
                filter.add(frame.func_82335_i());
            }
        }
        return filter;
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public boolean onWanded(EntityPlayer player, ItemStack wand) {
        if (player == null) {
            return false;
        }
        if (player.func_70093_af()) {
            this.filterType = this.filterType == 2 ? 0 : this.filterType + 1;
            this.sync();
            return true;
        }
        return super.onWanded(player, wand);
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_FILTER_TYPE, this.filterType);
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        this.filterType = cmp.func_74762_e(TAG_FILTER_TYPE);
    }

    @Override
    public void renderHUD(Minecraft mc, ScaledResolution res) {
        super.renderHUD(mc, res);
        int color = 0x66000000 | this.getColor();
        String filter = StatCollector.func_74838_a((String)("botaniamisc.filter" + this.filterType));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int x = res.func_78326_a() / 2 - mc.field_71466_p.func_78256_a(filter) / 2;
        int y = res.func_78328_b() / 2 + 30;
        mc.field_71466_p.func_78261_a(filter, x, y, color);
        GL11.glDisable((int)3042);
    }

    @Override
    public LexiconEntry getEntry() {
        return LexiconData.hopperhock;
    }

    @Override
    public int getMaxMana() {
        return 20;
    }

    @Override
    public int getColor() {
        return 0x3F3F3F;
    }
}

