/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public final class ConfigHandler {
    public static Configuration config;
    public static boolean useShaders;
    public static boolean lexiconRotatingItems;
    public static boolean subtlePowerSystem;
    public static boolean staticWandBeam;
    public static boolean boundBlockWireframe;
    public static boolean lexicon3dModel;
    public static boolean oldPylonModel;
    public static double flowerParticleFrequency;
    public static boolean blockBreakParticles;
    public static boolean blockBreakParticlesTool;
    public static boolean elfPortalParticlesEnabled;
    public static boolean matrixMode;
    public static boolean referencesEnabled;
    public static boolean versionCheckEnabled;
    public static int spreaderPositionShift;
    public static boolean flowerForceCheck;
    public static boolean fallenKanadeEnabled;
    public static boolean darkQuartzEnabled;
    public static int shedRateChicken;
    public static int shedRateSquid;
    public static int shedRateVillager;
    public static int shedRateSpider;
    public static int shedRateBlaze;
    public static int shedRateGhast;
    public static int shedRateSkeleton;
    public static int shedRateSlime;
    public static int flowerQuantity;
    public static int flowerDensity;

    public static void loadConfig(File configFile) {
        config = new Configuration(configFile);
        config.load();
        ConfigHandler.load();
        FMLCommonHandler.instance().bus().register((Object)new ChangeListener());
    }

    public static void load() {
        String desc = "Set to false to disable the use of shaders for some of the mod's renders.";
        useShaders = ConfigHandler.loadPropBool("shaders.enabled", desc, useShaders);
        desc = "Set to false to disable the rotating items in the petal and rune entries in the Lexica Botania.";
        lexiconRotatingItems = ConfigHandler.loadPropBool("lexicon.enable.rotatingItems", desc, lexiconRotatingItems);
        desc = "Set to true to set the power system's particles to be a lot more subtle. Good for low-end systems, if the particles are causing lag.";
        subtlePowerSystem = ConfigHandler.loadPropBool("powerSystem.subtle", desc, subtlePowerSystem);
        desc = "Set to true to use a static wand beam that shows every single position of the burst, similar to the way it used to work on old botania versions. Warning: Disabled by default because it may be laggy.";
        staticWandBeam = ConfigHandler.loadPropBool("wandBeam.static", desc, staticWandBeam);
        desc = "Set to false to disable the wireframe when looking a block bound to something (spreaders, flowers, etc).";
        boundBlockWireframe = ConfigHandler.loadPropBool("boundBlock.wireframe.enabled", desc, boundBlockWireframe);
        desc = "Set to false to disabled the animated 3D render for the lexica botania";
        lexicon3dModel = ConfigHandler.loadPropBool("lexicon.render.3D", desc, lexicon3dModel);
        desc = "Set to true to use the old (non-.obj, pre beta18) pylon model";
        oldPylonModel = ConfigHandler.loadPropBool("pylonModel.old", desc, oldPylonModel);
        desc = "The frequency in which particles spawn from normal (worldgen) mystical flowers";
        flowerParticleFrequency = ConfigHandler.loadPropDouble("flowerParticles.frequency", desc, flowerParticleFrequency);
        desc = "Set to false to remove the block breaking particles from the flowers and other items in the mod.";
        blockBreakParticles = ConfigHandler.loadPropBool("blockBreakingParticles.enabled", desc, blockBreakParticles);
        desc = "Set to false to remove the block breaking particles from the Mana Shatterer, as there can be a good amount in higher levels.";
        blockBreakParticlesTool = ConfigHandler.loadPropBool("blockBreakingParticlesTool.enabled", desc, blockBreakParticlesTool);
        desc = "Set to false to disable the particles in the elven portal.";
        elfPortalParticlesEnabled = ConfigHandler.loadPropBool("elfPortal.particles.enabled", desc, elfPortalParticlesEnabled);
        desc = "Set to true if you are the chosen one. For lovers of glitch art and just general mad people.";
        matrixMode = ConfigHandler.loadPropBool("matrixMode.enabled", desc, matrixMode);
        desc = "Set to false to disable the references in flower tooltips. (You monster D:)";
        referencesEnabled = ConfigHandler.loadPropBool("references.enabled", desc, referencesEnabled);
        desc = "Set to false to disable checking and alerting when new Botania versions come out.";
        versionCheckEnabled = ConfigHandler.loadPropBool("versionChecking.enabled", desc, versionCheckEnabled);
        desc = "Do not ever touch this value if not asked to. Possible symptoms of doing so include your head turning backwards, the appearance of Titans near the walls or you being trapped in a game of Sword Art Online.";
        spreaderPositionShift = ConfigHandler.loadPropInt("spreader.posShift", desc, spreaderPositionShift);
        desc = "Turn off ONLY IF you're on an extremely large world with an exhagerated count of Mana Spreaders/Mana Pools and are experiencing TPS lag. This toggles whether flowers are strict with their checking for connecting to pools/spreaders or just check whenever possible.";
        flowerForceCheck = ConfigHandler.loadPropBool("flower.forceCheck", desc, flowerForceCheck);
        desc = "Set to false to disable the Fallen Kanade flower (gives Regeneration). This config option is here for those using Blood Magic. Note: Turning this off will not remove ones already in the world, it'll simply prevent the crafting.";
        fallenKanadeEnabled = ConfigHandler.loadPropBool("fallenKanade.enabled", desc, fallenKanadeEnabled);
        desc = "Set to false to disable the Smokey Quartz blocks. This config option is here for those using Thaumic Tinkerer";
        darkQuartzEnabled = ConfigHandler.loadPropBool("darkQuartz.enabled", desc, darkQuartzEnabled);
        desc = "The average amount of ticks between a chicken randomly dropping a feather. Set to -1 to disable this feature";
        shedRateChicken = ConfigHandler.loadPropInt("shedRate.chicken", desc, shedRateChicken);
        desc = "The average amount of ticks between a squid randomly dropping an ink sac. Set to -1 to disable this feature";
        shedRateSquid = ConfigHandler.loadPropInt("shedRate.squid", desc, shedRateSquid);
        desc = "The average amount of ticks between a villager randomly dropping an emerald. Set to -1 to disable this feature";
        shedRateVillager = ConfigHandler.loadPropInt("shedRate.villager", desc, shedRateVillager);
        desc = "The average amount of ticks between a spider randomly dropping a piece of string. Set to -1 to disable this feature";
        shedRateSpider = ConfigHandler.loadPropInt("shedRate.spider", desc, shedRateSpider);
        desc = "The average amount of ticks between a blaze randomly dropping a piece of blaze powder. Set to -1 to disable this feature";
        shedRateBlaze = ConfigHandler.loadPropInt("shedRate.blaze", desc, shedRateBlaze);
        desc = "The average amount of ticks between a ghast randomly dropping a ghast tear. Set to -1 to disable this feature";
        shedRateGhast = ConfigHandler.loadPropInt("shedRate.ghast", desc, shedRateGhast);
        desc = "The average amount of ticks between a skeleton randomly dropping a bone. Set to -1 to disable this feature";
        shedRateSkeleton = ConfigHandler.loadPropInt("shedRate.skeleton", desc, shedRateSkeleton);
        desc = "The average amount of ticks between a slime randomly dropping a slimeball. Set to -1 to disable this feature";
        shedRateSlime = ConfigHandler.loadPropInt("shedRate.slime", desc, shedRateSlime);
        desc = "The quanity of flower patches to generate in the world, defaults to 3, the lower the number the less patches geenrate.";
        flowerQuantity = ConfigHandler.loadPropInt("worldgen.flower.quantity", desc, 3);
        desc = "The density of each flower patch generataed, defaults to 32, the lower the number, the less each patch will have.";
        flowerDensity = ConfigHandler.loadPropInt("worldgen.flower.density", desc, 32);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static int loadPropInt(String propName, String desc, int default_) {
        Property prop = config.get("general", propName, default_);
        prop.comment = desc;
        return prop.getInt(default_);
    }

    public static double loadPropDouble(String propName, String desc, double default_) {
        Property prop = config.get("general", propName, default_);
        prop.comment = desc;
        return prop.getDouble(default_);
    }

    public static boolean loadPropBool(String propName, String desc, boolean default_) {
        Property prop = config.get("general", propName, default_);
        prop.comment = desc;
        return prop.getBoolean(default_);
    }

    static {
        useShaders = true;
        lexiconRotatingItems = true;
        subtlePowerSystem = false;
        staticWandBeam = false;
        boundBlockWireframe = true;
        lexicon3dModel = true;
        oldPylonModel = false;
        flowerParticleFrequency = 0.75;
        blockBreakParticles = true;
        blockBreakParticlesTool = true;
        elfPortalParticlesEnabled = true;
        matrixMode = false;
        referencesEnabled = true;
        versionCheckEnabled = true;
        spreaderPositionShift = 1;
        flowerForceCheck = true;
        fallenKanadeEnabled = true;
        darkQuartzEnabled = true;
        shedRateChicken = 26000;
        shedRateSquid = 18000;
        shedRateVillager = 82000;
        shedRateSpider = 12000;
        shedRateBlaze = 8000;
        shedRateGhast = 9001;
        shedRateSkeleton = 36000;
        shedRateSlime = 21000;
        flowerQuantity = 3;
        flowerDensity = 32;
    }

    public static class ChangeListener {
        @SubscribeEvent
        public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
            if (eventArgs.modID.equals("Botania")) {
                ConfigHandler.load();
            }
        }
    }
}

