/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.ILexicon;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.KnowledgeType;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.recipe.IElvenItem;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.item.ItemMod;
import vazkii.botania.common.lexicon.LexiconData;

public class ItemLexicon
extends ItemMod
implements ILexicon,
IElvenItem {
    private static final String TAG_KNOWLEDGE_PREFIX = "knowledge.";
    private static final String TAG_FORCED_MESSAGE = "forcedMessage";

    public ItemLexicon() {
        this.func_77625_d(1);
        this.func_77655_b("lexicon");
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        LexiconEntry entry;
        Block block;
        if (par2EntityPlayer.func_70093_af() && (block = par3World.func_147439_a(par4, par5, par6)) != null && block instanceof ILexiconable && (entry = ((ILexiconable)block).getEntry(par3World, par4, par5, par6, par2EntityPlayer, par1ItemStack)) != null) {
            Botania.proxy.setEntryToOpen(entry);
            par2EntityPlayer.openGui((Object)Botania.instance, 0, par3World, 0, 0, 0);
            return true;
        }
        return false;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item));
        ItemStack creative = new ItemStack(item);
        for (String s : BotaniaAPI.knowledgeTypes.keySet()) {
            KnowledgeType type = BotaniaAPI.knowledgeTypes.get(s);
            this.unlockKnowledge(creative, type);
        }
        list.add(creative);
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        if (GuiScreen.func_146272_n()) {
            String edition = EnumChatFormatting.GOLD + String.format(StatCollector.func_74838_a((String)"botaniamisc.edition"), ItemLexicon.getEdition());
            if (!edition.isEmpty()) {
                par3List.add(edition);
            }
            ArrayList<KnowledgeType> typesKnown = new ArrayList<KnowledgeType>();
            for (String s : BotaniaAPI.knowledgeTypes.keySet()) {
                KnowledgeType type = BotaniaAPI.knowledgeTypes.get(s);
                if (!this.isKnowledgeUnlocked(par1ItemStack, type)) continue;
                typesKnown.add(type);
            }
            String format = typesKnown.size() == 1 ? "botaniamisc.knowledgeTypesSingular" : "botaniamisc.knowledgeTypesPlural";
            this.addStringToTooltip(String.format(StatCollector.func_74838_a((String)format), typesKnown.size()), par3List);
            for (KnowledgeType type : typesKnown) {
                this.addStringToTooltip(" \u2022 " + StatCollector.func_74838_a((String)type.getUnlocalizedName()), par3List);
            }
        } else {
            this.addStringToTooltip(StatCollector.func_74838_a((String)"botaniamisc.shiftinfo"), par3List);
        }
    }

    private void addStringToTooltip(String s, List<String> tooltip) {
        tooltip.add(s.replaceAll("&", "\u00a7"));
    }

    public static String getEdition() {
        String version = "74";
        int build = version.contains("ANT") ? 0 : Integer.parseInt(version);
        return build == 0 ? StatCollector.func_74838_a((String)"botaniamisc.devEdition") : MathHelper.numberToOrdinal(build);
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (ItemLexicon.isMessageForced(par1ItemStack)) {
            Botania.proxy.setEntryToOpen(LexiconData.elvenMessage);
            ItemLexicon.forceMessage(par1ItemStack, false);
        }
        par3EntityPlayer.openGui((Object)Botania.instance, 0, par2World, 0, 0, 0);
        return par1ItemStack;
    }

    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.uncommon;
    }

    @Override
    public boolean isKnowledgeUnlocked(ItemStack stack, KnowledgeType knowledge) {
        return knowledge.autoUnlock || ItemNBTHelper.getBoolean(stack, TAG_KNOWLEDGE_PREFIX + knowledge.id, false);
    }

    @Override
    public void unlockKnowledge(ItemStack stack, KnowledgeType knowledge) {
        ItemNBTHelper.setBoolean(stack, TAG_KNOWLEDGE_PREFIX + knowledge.id, true);
    }

    public static void forceMessage(ItemStack stack, boolean forced) {
        ItemNBTHelper.setBoolean(stack, TAG_FORCED_MESSAGE, forced);
    }

    public static boolean isMessageForced(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_FORCED_MESSAGE, false);
    }

    @Override
    public boolean isElvenItem(ItemStack stack) {
        return this.isKnowledgeUnlocked(stack, BotaniaAPI.elvenKnowledge);
    }
}

