/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import baubles.api.BaubleType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class ItemIcePendant
extends ItemBauble {
    public static Map<String, List<IceRemover>> playerIceBlocks = new HashMap<String, List<IceRemover>>();

    public ItemIcePendant() {
        super("icePendant");
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.AMULET;
    }

    @Override
    public void onWornTick(ItemStack stack, EntityLivingBase entity) {
        super.onWornTick(stack, entity);
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!player.field_70170_p.field_72995_K) {
                this.tickIceRemovers(player);
            }
            if (!player.func_70093_af() && !player.func_70055_a(Material.field_151586_h)) {
                int x = MathHelper.func_76128_c((double)player.field_70165_t);
                int y = MathHelper.func_76128_c((double)(player.field_70163_u - (double)(!player.func_70090_H() ? 1 : 0) - (double)(player.field_70170_p.field_72995_K ? 1 : 0)));
                int z = MathHelper.func_76128_c((double)player.field_70161_v);
                int range = 3;
                for (int i = -range - 1; i < range; ++i) {
                    for (int j = -range; j < range + 1; ++j) {
                        int x1 = x + i;
                        int z1 = z + j;
                        this.addIceBlock(player, new ChunkCoordinates(x1, y, z1));
                    }
                }
            }
        }
    }

    private void addIceBlock(EntityPlayer player, ChunkCoordinates coords) {
        String user = player.func_70005_c_();
        if (!playerIceBlocks.containsKey(user)) {
            playerIceBlocks.put(user, new ArrayList());
        }
        List<IceRemover> ice = playerIceBlocks.get(user);
        if (player.field_70170_p.func_147439_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c) == Blocks.field_150355_j && player.field_70170_p.func_72805_g(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c) == 0) {
            player.field_70170_p.func_147449_b(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, Blocks.field_150432_aD);
            if (!player.field_70170_p.field_72995_K) {
                ice.add(new IceRemover(coords));
            }
        }
    }

    private void tickIceRemovers(EntityPlayer player) {
        String user = player.func_70005_c_();
        if (!playerIceBlocks.containsKey(user)) {
            return;
        }
        List<IceRemover> removers = playerIceBlocks.get(user);
        for (IceRemover ice : new ArrayList<IceRemover>(removers)) {
            ice.tick(player.field_70170_p, removers);
        }
    }

    class IceRemover {
        int time = 30;
        final ChunkCoordinates coords;

        public IceRemover(ChunkCoordinates coords) {
            this.coords = coords;
        }

        public void tick(World world, List<IceRemover> list) {
            if (world.func_147439_a(this.coords.field_71574_a, this.coords.field_71572_b, this.coords.field_71573_c) == Blocks.field_150432_aD) {
                if (this.time-- != 0) {
                    return;
                }
                world.func_147465_d(this.coords.field_71574_a, this.coords.field_71572_b, this.coords.field_71573_c, Blocks.field_150355_j, 0, 3);
                list.remove(this);
            }
        }
    }
}

