/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.client.render.IModelRegister;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.BotaniaCreativeTab;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockModFlower
extends BlockFlower
implements ILexiconable,
IGrowable,
IModelRegister {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.3, 0.0, 0.3, 0.8, 1.0, 0.8);

    protected BlockModFlower() {
        this("flower");
    }

    protected BlockModFlower(String name) {
        this.func_149663_c(name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.COLOR, (Comparable)EnumDyeColor.WHITE).func_177226_a((IProperty)this.field_176496_a, (Comparable)BlockFlower.EnumFlowerType.POPPY));
        this.setRegistryName(new ResourceLocation("botania", name));
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(false);
        this.func_149647_a(this.registerInCreative() ? BotaniaCreativeTab.INSTANCE : null);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return AABB.func_191194_a(state.func_191059_e(world, pos));
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.func_176494_l(), BotaniaStateProps.COLOR});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(BotaniaStateProps.COLOR)).func_176765_a();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (meta >= EnumDyeColor.values().length) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a(BotaniaStateProps.COLOR, (Comparable)EnumDyeColor.func_176764_b((int)meta));
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)this.field_176496_a, (Comparable)BlockFlower.EnumFlowerType.POPPY);
    }

    @Nonnull
    public BlockFlower.EnumFlowerColor func_176495_j() {
        return BlockFlower.EnumFlowerColor.RED;
    }

    public boolean registerInCreative() {
        return true;
    }

    public void func_149666_a(CreativeTabs tab, @Nonnull NonNullList<ItemStack> stacks) {
        for (int i = 0; i < 16; ++i) {
            stacks.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        int hex = ((EnumDyeColor)state.func_177229_b(BotaniaStateProps.COLOR)).func_193350_e();
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        Vec3d offset = state.func_191059_e((IBlockAccess)world, pos);
        double x = (double)pos.func_177958_n() + offset.field_72450_a;
        double y = (double)pos.func_177956_o() + offset.field_72448_b;
        double z = (double)pos.func_177952_p() + offset.field_72449_c;
        if (rand.nextDouble() < ConfigHandler.flowerParticleFrequency) {
            Botania.proxy.sparkleFX(x + 0.3 + (double)rand.nextFloat() * 0.5, y + 0.5 + (double)rand.nextFloat() * 0.5, z + 0.3 + (double)rand.nextFloat() * 0.5, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, rand.nextFloat(), 5);
        }
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.flowers;
    }

    public boolean func_176473_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean fuckifiknow) {
        return world.func_175623_d(pos.func_177984_a());
    }

    public boolean func_180670_a(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return this.func_176473_a(world, pos, state, false);
    }

    public void func_176474_b(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        BlockModFlower.placeDoubleFlower(world, pos, (EnumDyeColor)state.func_177229_b(BotaniaStateProps.COLOR), 3);
    }

    public static void placeDoubleFlower(World world, BlockPos pos, EnumDyeColor color, int flags) {
        Block flower = color.func_176765_a() >= 8 ? ModBlocks.doubleFlower2 : ModBlocks.doubleFlower1;
        world.func_180501_a(pos, flower.func_176223_P().func_177226_a(color.func_176765_a() >= 8 ? BotaniaStateProps.DOUBLEFLOWER_VARIANT_2 : BotaniaStateProps.DOUBLEFLOWER_VARIANT_1, (Comparable)color).func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.LOWER), flags);
        world.func_180501_a(pos.func_177984_a(), flower.func_176223_P().func_177226_a(color.func_176765_a() >= 8 ? BotaniaStateProps.DOUBLEFLOWER_VARIANT_2 : BotaniaStateProps.DOUBLEFLOWER_VARIANT_1, (Comparable)color).func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.UPPER), flags);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{this.func_176494_l()}).func_178441_a());
        ModelHandler.registerCustomItemblock((Block)this, EnumDyeColor.values().length, i -> "flower_" + EnumDyeColor.func_176764_b((int)i).func_176610_l());
    }
}

