/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IWireframeCoordinateListProvider;
import vazkii.botania.api.wand.ICoordBoundItem;
import vazkii.botania.api.wand.IWireframeAABBProvider;
import vazkii.botania.client.core.handler.ClientTickHandler;

public final class BoundTileRenderer {
    private BoundTileRenderer() {
    }

    @SubscribeEvent
    public static void onWorldRenderLast(RenderWorldLastEvent event) {
        BlockPos coords;
        GlStateManager.pushMatrix();
        GL11.glPushAttrib((int)64);
        GlStateManager.disableDepthTest();
        GlStateManager.disableTexture();
        GlStateManager.enableBlend();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        int color = Color.HSBtoRGB((float)(ClientTickHandler.ticksInGame % 200) / 200.0f, 0.6f, 1.0f);
        if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof ICoordBoundItem && (coords = ((ICoordBoundItem)player.func_184614_ca().func_77973_b()).getBinding(player.func_184614_ca())) != null) {
            BoundTileRenderer.renderBlockOutlineAt(coords, color);
        }
        if (!player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() instanceof ICoordBoundItem && (coords = ((ICoordBoundItem)player.func_184592_cb().func_77973_b()).getBinding(player.func_184592_cb())) != null) {
            BoundTileRenderer.renderBlockOutlineAt(coords, color);
        }
        LazyOptional mainInvCap = player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP);
        mainInvCap.ifPresent(arg_0 -> BoundTileRenderer.lambda$onWorldRenderLast$0((PlayerEntity)player, color, arg_0));
        GlStateManager.enableDepthTest();
        GlStateManager.enableTexture();
        GlStateManager.disableBlend();
        GL11.glPopAttrib();
        GlStateManager.popMatrix();
    }

    private static void renderBlockOutlineAt(BlockPos pos, int color) {
        BoundTileRenderer.renderBlockOutlineAt(pos, color, 1.0f);
    }

    private static void renderBlockOutlineAt(BlockPos pos, int color, float thickness) {
        double renderPosX = Minecraft.func_71410_x().func_175598_ae().field_78725_b;
        double renderPosY = Minecraft.func_71410_x().func_175598_ae().field_78726_c;
        double renderPosZ = Minecraft.func_71410_x().func_175598_ae().field_78723_d;
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)((double)pos.func_177958_n() - renderPosX), (double)((double)pos.func_177956_o() - renderPosY), (double)((double)pos.func_177952_p() - renderPosZ + 1.0));
        Color colorRGB = new Color(color);
        GlStateManager.color4f((float)((float)colorRGB.getRed() / 255.0f), (float)((float)colorRGB.getGreen() / 255.0f), (float)((float)colorRGB.getBlue() / 255.0f), (float)1.0f);
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        List<AxisAlignedBB> list = null;
        if (block instanceof IWireframeAABBProvider) {
            list = ((IWireframeAABBProvider)block).getWireframeAABB((World)world, pos);
        } else {
            VoxelShape shape = state.func_196954_c((IBlockReader)world, pos);
            if (!shape.func_197766_b()) {
                list = Collections.singletonList(shape.func_197752_a().func_186670_a(pos));
            }
        }
        if (list != null) {
            GlStateManager.scalef((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.lineWidth((float)thickness);
            for (AxisAlignedBB axis : list) {
                axis = axis.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-(pos.func_177952_p() + 1)));
                BoundTileRenderer.renderBlockOutline(axis);
            }
            GlStateManager.lineWidth((float)(thickness + 3.0f));
            GlStateManager.color4f((float)((float)colorRGB.getRed() / 255.0f), (float)((float)colorRGB.getGreen() / 255.0f), (float)((float)colorRGB.getBlue() / 255.0f), (float)0.25f);
            for (AxisAlignedBB axis : list) {
                axis = axis.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-(pos.func_177952_p() + 1)));
                BoundTileRenderer.renderBlockOutline(axis);
            }
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
    }

    private static void renderBlockOutline(AxisAlignedBB aabb) {
        Tessellator tessellator = Tessellator.func_178181_a();
        double ix = aabb.field_72340_a;
        double iy = aabb.field_72338_b;
        double iz = aabb.field_72339_c;
        double ax = aabb.field_72336_d;
        double ay = aabb.field_72337_e;
        double az = aabb.field_72334_f;
        tessellator.func_178180_c().func_181668_a(1, DefaultVertexFormats.field_181705_e);
        tessellator.func_178180_c().func_181662_b(ix, iy, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, ay, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, ay, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, ay, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, ay, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, iy, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, iy, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, iy, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, iy, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, ay, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, iy, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, iy, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, iy, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, ay, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, ay, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, ay, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, iy, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, iy, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, ay, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, ay, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, iy, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, iy, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, ay, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, ay, az).func_181675_d();
        tessellator.func_78381_a();
    }

    private static /* synthetic */ void lambda$onWorldRenderLast$0(PlayerEntity player, int color, IItemHandler mainInv) {
        IItemHandlerModifiable acc = BotaniaAPI.internalHandler.getAccessoriesInventory(player);
        IItemHandler joined = acc != null ? new CombinedInvWrapper(new IItemHandlerModifiable[]{(IItemHandlerModifiable)mainInv, acc}) : mainInv;
        for (int i = 0; i < joined.getSlots(); ++i) {
            ItemStack stackInSlot = joined.getStackInSlot(i);
            if (stackInSlot.func_190926_b() || !(stackInSlot.func_77973_b() instanceof IWireframeCoordinateListProvider)) continue;
            IWireframeCoordinateListProvider provider = (IWireframeCoordinateListProvider)stackInSlot.func_77973_b();
            List<BlockPos> coordsList = provider.getWireframesToDraw(player, stackInSlot);
            for (BlockPos coords : coordsList) {
                BoundTileRenderer.renderBlockOutlineAt(coords, color);
            }
            BlockPos coords = provider.getSourceWireframe(player, stackInSlot);
            if (coords == null || coords.func_177956_o() <= -1) continue;
            BoundTileRenderer.renderBlockOutlineAt(coords, color, 5.0f);
        }
    }
}

