/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.fx;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import vazkii.botania.client.fx.ModParticles;

public class WispParticleData
implements IParticleData {
    public final float size;
    public final float r;
    public final float g;
    public final float b;
    public final float maxAgeMul;
    public final boolean depthTest;
    public final boolean noClip;
    public static final IParticleData.IDeserializer<WispParticleData> DESERIALIZER = new IParticleData.IDeserializer<WispParticleData>(){

        @Nonnull
        public WispParticleData deserialize(@Nonnull ParticleType<WispParticleData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float size = reader.readFloat();
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            reader.expect(' ');
            float mam = reader.readFloat();
            boolean depth = true;
            if (reader.canRead()) {
                reader.expect(' ');
                depth = reader.readBoolean();
            }
            boolean noClip = false;
            if (reader.canRead()) {
                reader.expect(' ');
                depth = reader.readBoolean();
            }
            return new WispParticleData(size, r, g, b, mam, depth, noClip);
        }

        public WispParticleData read(@Nonnull ParticleType<WispParticleData> type, PacketBuffer buf) {
            return new WispParticleData(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readBoolean(), buf.readBoolean());
        }
    };

    public static WispParticleData wisp(float size, float r, float g, float b) {
        return WispParticleData.wisp(size, r, g, b, 1.0f);
    }

    public static WispParticleData wisp(float size, float r, float g, float b, float maxAgeMul) {
        return WispParticleData.wisp(size, r, g, b, maxAgeMul, true);
    }

    public static WispParticleData wisp(float size, float r, float g, float b, boolean depth) {
        return WispParticleData.wisp(size, r, g, b, 1.0f, depth);
    }

    public static WispParticleData wisp(float size, float r, float g, float b, float maxAgeMul, boolean depthTest) {
        return new WispParticleData(size, r, g, b, maxAgeMul, depthTest, false);
    }

    private WispParticleData(float size, float r, float g, float b, float maxAgeMul, boolean depthTest, boolean noClip) {
        this.size = size;
        this.r = r;
        this.g = g;
        this.b = b;
        this.maxAgeMul = maxAgeMul;
        this.depthTest = depthTest;
        this.noClip = noClip;
    }

    public WispParticleData withNoClip(boolean v) {
        if (this.noClip == v) {
            return this;
        }
        return new WispParticleData(this.size, this.r, this.g, this.b, this.maxAgeMul, this.depthTest, v);
    }

    @Nonnull
    public ParticleType<WispParticleData> func_197554_b() {
        return ModParticles.WISP;
    }

    public void func_197553_a(PacketBuffer buf) {
        buf.writeFloat(this.size);
        buf.writeFloat(this.r);
        buf.writeFloat(this.g);
        buf.writeFloat(this.b);
        buf.writeFloat(this.maxAgeMul);
        buf.writeBoolean(this.depthTest);
        buf.writeBoolean(this.noClip);
    }

    @Nonnull
    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %s", this.func_197554_b().getRegistryName(), Float.valueOf(this.size), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.maxAgeMul), this.depthTest);
    }
}

