/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.BasicState;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.botania.common.item.ItemManaGun;

public class GunModel
implements IBakedModel {
    private static final ModelResourceLocation DESU = new ModelResourceLocation("botania:desu_gun", "inventory");
    private static final ModelResourceLocation DESU_CLIP = new ModelResourceLocation("botania:desu_gun_clip", "inventory");
    private final ModelBakery bakery;
    private final IBakedModel originalModel;
    private final IBakedModel originalModelClip;
    private final ItemOverrideList itemHandler = new ItemOverrideList(){

        @Nonnull
        public IBakedModel func_209581_a(IBakedModel model, ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entityIn) {
            boolean clip = ItemManaGun.hasClip(stack);
            if (ItemManaGun.isSugoiKawaiiDesuNe(stack)) {
                return Minecraft.func_71410_x().func_209506_al().func_174953_a(clip ? DESU_CLIP : DESU);
            }
            ItemStack lens = ItemManaGun.getLens(stack);
            if (!lens.func_190926_b()) {
                ModelResourceLocation mrl = new ModelResourceLocation(lens.func_77973_b().getRegistryName(), "inventory");
                IUnbakedModel unbaked = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)mrl);
                return GunModel.this.getModel(unbaked, clip);
            }
            return clip ? GunModel.this.originalModelClip : GunModel.this.originalModel;
        }
    };
    private final HashMap<Pair<IUnbakedModel, Boolean>, CompositeBakedModel> cache = new HashMap();

    public GunModel(ModelBakery bakery, IBakedModel originalModel, IBakedModel originalModelClip) {
        this.bakery = bakery;
        this.originalModel = (IBakedModel)Preconditions.checkNotNull((Object)originalModel);
        this.originalModelClip = (IBakedModel)Preconditions.checkNotNull((Object)originalModelClip);
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.itemHandler;
    }

    @Nonnull
    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand) {
        return this.originalModel.func_200117_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.originalModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.originalModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.originalModel.func_188618_c();
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.originalModel.func_177554_e();
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return this.originalModel.func_177552_f();
    }

    private CompositeBakedModel getModel(IUnbakedModel lens, boolean clip) {
        return this.cache.computeIfAbsent((Pair<IUnbakedModel, Boolean>)Pair.of((Object)lens, (Object)clip), p -> new CompositeBakedModel(this.bakery, (IUnbakedModel)p.getLeft(), (Boolean)p.getRight() != false ? this.originalModelClip : this.originalModel));
    }

    private static class CompositeBakedModel
    implements IBakedModel {
        private final IBakedModel gun;
        private final List<BakedQuad> genQuads = new ArrayList<BakedQuad>();
        private final Map<Direction, List<BakedQuad>> faceQuads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);

        CompositeBakedModel(ModelBakery bakery, IUnbakedModel lensUnbaked, IBakedModel gun) {
            this.gun = gun;
            TRSRTransformation transform = new TRSRTransformation(new Vector3f(-0.2f, 0.4f, 0.8f), TRSRTransformation.quatFromXYZ((float)0.0f, (float)1.5707964f, (float)0.0f), new Vector3f(0.625f, 0.625f, 0.625f), null);
            IBakedModel lens = lensUnbaked.bake(bakery, ModelLoader.defaultTextureGetter(), (ISprite)new BasicState((IModelState)transform, false), DefaultVertexFormats.field_176599_b);
            for (Direction e : Direction.values()) {
                this.faceQuads.put(e, new ArrayList());
            }
            Random rand = new Random(0L);
            this.genQuads.addAll(lens.func_200117_a(null, null, rand));
            for (Direction e : Direction.values()) {
                rand.setSeed(0L);
                this.faceQuads.get(e).addAll(lens.func_200117_a(null, e, rand));
            }
            rand.setSeed(0L);
            this.genQuads.addAll(gun.func_200117_a(null, null, rand));
            for (Direction e : Direction.values()) {
                rand.setSeed(0L);
                this.faceQuads.get(e).addAll(gun.func_200117_a(null, e, rand));
            }
        }

        @Nonnull
        public List<BakedQuad> func_200117_a(BlockState state, Direction face, @Nonnull Random rand) {
            return face == null ? this.genQuads : this.faceQuads.get(face);
        }

        public boolean func_177555_b() {
            return this.gun.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.gun.func_177556_c();
        }

        public boolean func_188618_c() {
            return this.gun.func_188618_c();
        }

        @Nonnull
        public TextureAtlasSprite func_177554_e() {
            return this.gun.func_177554_e();
        }

        @Nonnull
        public ItemCameraTransforms func_177552_f() {
            return this.gun.func_177552_f();
        }

        @Nonnull
        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType) {
            Pair pair = this.gun.handlePerspective(cameraTransformType);
            if (pair != null && pair.getRight() != null) {
                return Pair.of((Object)this, (Object)pair.getRight());
            }
            return Pair.of((Object)this, (Object)TRSRTransformation.identity().getMatrixVec());
        }
    }
}

