/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.MovingPistonBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.PistonType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketHandler;

public class BlockPistonRelay
extends BlockMod
implements IWandable {
    public final Map<UUID, GlobalPos> activeBindingAttempts = new HashMap<UUID, GlobalPos>();
    public final Map<GlobalPos, GlobalPos> mappedPositions = new HashMap<GlobalPos, GlobalPos>();
    private final Set<GlobalPos> removeQueue = new HashSet<GlobalPos>();
    private final Set<GlobalPos> checkedCoords = new HashSet<GlobalPos>();
    private final Map<GlobalPos, Integer> coordsToCheck = new HashMap<GlobalPos, Integer>();

    public BlockPistonRelay(Block.Properties builder) {
        super(builder);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean func_220067_a(BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, EntityType<?> type) {
        return false;
    }

    public void func_196243_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!world.field_72995_K) {
            this.mapCoords(world.func_201675_m().func_186058_p(), pos, 2);
        }
    }

    private void mapCoords(DimensionType type, BlockPos pos, int time) {
        this.coordsToCheck.put(GlobalPos.func_218179_a((DimensionType)type, (BlockPos)pos), time);
    }

    private void decrCoords(GlobalPos key) {
        int time = this.getTimeInCoords(key);
        if (time <= 0) {
            this.removeQueue.add(key);
        } else {
            this.coordsToCheck.merge(key, -1, Integer::sum);
        }
    }

    private int getTimeInCoords(GlobalPos key) {
        return this.coordsToCheck.getOrDefault(key, 0);
    }

    private Block getBlockAt(GlobalPos key) {
        return this.getStateAt(key).func_177230_c();
    }

    private BlockState getStateAt(GlobalPos key) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return server.func_71218_a(key.func_218177_a()).func_180495_p(key.func_218180_b());
    }

    @Override
    public boolean onUsedByWand(PlayerEntity player, ItemStack stack, World world, BlockPos pos, Direction side) {
        if (player == null || world.field_72995_K) {
            return false;
        }
        if (!player.func_70093_af()) {
            GlobalPos clicked = GlobalPos.func_218179_a((DimensionType)world.func_201675_m().func_186058_p(), (BlockPos)pos.func_185334_h());
            if (ItemTwigWand.getBindMode(stack)) {
                this.activeBindingAttempts.put(player.func_110124_au(), clicked);
                world.func_184133_a(null, pos, ModSounds.ding, SoundCategory.BLOCKS, 0.5f, 1.0f);
            } else {
                GlobalPos dest = this.mappedPositions.get(clicked);
                if (dest != null) {
                    PacketHandler.sendToNearby(world, pos, (Object)new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.PARTICLE_BEAM, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, dest.func_218180_b().func_177958_n(), dest.func_218180_b().func_177956_o(), dest.func_218180_b().func_177952_p()));
                }
            }
        } else {
            BlockPistonRelay.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)this));
            world.func_175655_b(pos, false);
        }
        return true;
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().func_201672_e().field_72995_K && event.getWorld().func_201675_m().func_186058_p() == DimensionType.field_223227_a_) {
            WorldData.get(event.getWorld().func_201672_e());
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().func_201672_e().field_72995_K && event.getWorld().func_201675_m().func_186058_p() == DimensionType.field_223227_a_) {
            WorldData.get(event.getWorld().func_201672_e()).func_76185_a();
        }
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.ServerTickEvent event) {
        if (event.type == TickEvent.Type.SERVER && event.phase == TickEvent.Phase.END) {
            for (GlobalPos s : this.coordsToCheck.keySet()) {
                Block block;
                this.decrCoords(s);
                if (this.checkedCoords.contains(s) || (block = this.getBlockAt(s)) != Blocks.field_196603_bb) continue;
                BlockState state = this.getStateAt(s);
                boolean sticky = PistonType.STICKY == state.func_177229_b((IProperty)MovingPistonBlock.field_196345_b);
                Direction dir = (Direction)state.func_177229_b((IProperty)MovingPistonBlock.field_196344_a);
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server == null || this.getTimeInCoords(s) != 0) continue;
                int x = s.func_218180_b().func_177958_n();
                int y = s.func_218180_b().func_177956_o();
                int z = s.func_218180_b().func_177952_p();
                BlockPos pos = s.func_218180_b();
                ServerWorld world = server.func_71218_a(s.func_218177_a());
                if (world.func_175623_d(pos.func_177972_a(dir))) {
                    world.func_175656_a(pos.func_177972_a(dir), ModBlocks.pistonRelay.func_176223_P());
                } else if (!world.field_72995_K) {
                    ItemStack stack = new ItemStack((IItemProvider)ModBlocks.pistonRelay);
                    world.func_217376_c((Entity)new ItemEntity((World)world, (double)(x + dir.func_82601_c()), (double)(y + dir.func_96559_d()), (double)(z + dir.func_82599_e()), stack));
                }
                this.checkedCoords.add(s);
                GlobalPos newPos = GlobalPos.func_218179_a((DimensionType)world.func_201675_m().func_186058_p(), (BlockPos)pos.func_177972_a(dir));
                if (!this.mappedPositions.containsKey(s)) continue;
                GlobalPos dest = this.mappedPositions.get(s);
                BlockPos destPos = dest.func_218180_b();
                ServerWorld world2 = server.func_71218_a(dest.func_218177_a());
                BlockState srcState = world2.func_180495_p(destPos);
                TileEntity tile = world2.func_175625_s(destPos);
                if (!sticky && tile == null && srcState.func_185905_o() == PushReaction.NORMAL && srcState.func_185887_b((IBlockReader)world2, destPos) != -1.0f && !srcState.isAir((IBlockReader)world2, destPos)) {
                    Material destMat = world2.func_180495_p(destPos.func_177972_a(dir)).func_185904_a();
                    if (world2.func_175623_d(destPos.func_177972_a(dir)) || destMat.func_76222_j()) {
                        world2.func_175656_a(destPos, Blocks.field_150350_a.func_176223_P());
                        world2.func_175656_a(destPos.func_177972_a(dir), srcState);
                        this.mappedPositions.put(s, GlobalPos.func_218179_a((DimensionType)world2.func_201675_m().func_186058_p(), (BlockPos)destPos.func_177972_a(dir)));
                    }
                }
                dest = this.mappedPositions.get(s);
                this.mappedPositions.remove(s);
                this.mappedPositions.put(newPos, dest);
                this.save((World)world2);
            }
        }
        this.coordsToCheck.keySet().removeAll(this.removeQueue);
        this.checkedCoords.removeAll(this.removeQueue);
        this.removeQueue.clear();
    }

    private void save(World world) {
        WorldData data = WorldData.get(world);
        if (data != null) {
            data.func_76185_a();
        }
    }

    public static class WorldData
    extends WorldSavedData {
        private static final String ID = "PistonRelayPairs";

        public WorldData() {
            super(ID);
        }

        public void func_76184_a(@Nonnull CompoundNBT cmp) {
            ((BlockPistonRelay)ModBlocks.pistonRelay).mappedPositions.clear();
            ListNBT list = cmp.func_150295_c("list", 10);
            for (int i = 0; i < list.size(); i += 2) {
                CompoundNBT from = list.func_150305_b(i);
                CompoundNBT to = list.func_150305_b(i + 1);
                GlobalPos fromPos = GlobalPos.func_218176_a((Dynamic)new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)from));
                GlobalPos toPos = GlobalPos.func_218176_a((Dynamic)new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)to));
                ((BlockPistonRelay)ModBlocks.pistonRelay).mappedPositions.put(fromPos, toPos);
            }
        }

        @Nonnull
        public CompoundNBT func_189551_b(@Nonnull CompoundNBT cmp) {
            ListNBT list = new ListNBT();
            for (Map.Entry<GlobalPos, GlobalPos> e : ((BlockPistonRelay)ModBlocks.pistonRelay).mappedPositions.entrySet()) {
                list.add(e.getKey().func_218175_a((DynamicOps)NBTDynamicOps.field_210820_a));
                list.add(e.getValue().func_218175_a((DynamicOps)NBTDynamicOps.field_210820_a));
            }
            cmp.func_218657_a("list", (INBT)list);
            return cmp;
        }

        public static WorldData get(World world) {
            WorldData data = (WorldData)((ServerWorld)world).func_217481_x().func_215753_b(WorldData::new, ID);
            if (data == null) {
                data = new WorldData();
                data.func_76185_a();
                ((ServerWorld)world).func_217481_x().func_215757_a((WorldSavedData)data);
            }
            return data;
        }
    }
}

