/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.material.Material;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.ModSounds;

public class SubTileAgricarnation
extends TileEntityFunctionalFlower {
    @ObjectHolder(value="botania:agricarnation")
    public static TileEntityType<SubTileAgricarnation> TYPE;
    private static final int RANGE = 5;
    private static final int RANGE_MINI = 2;

    public SubTileAgricarnation(TileEntityType<?> type) {
        super(type);
    }

    public SubTileAgricarnation() {
        this(TYPE);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.ticksExisted % 200 == 0) {
            this.sync();
        }
        if (this.ticksExisted % 6 == 0 && this.redstoneSignal == 0) {
            int range = this.getRange();
            int x = this.getEffectivePos().func_177958_n() + this.func_145831_w().field_73012_v.nextInt(range * 2 + 1) - range;
            int z = this.getEffectivePos().func_177952_p() + this.func_145831_w().field_73012_v.nextInt(range * 2 + 1) - range;
            for (int i = 4; i > -2; --i) {
                int y = this.getEffectivePos().func_177956_o() + i;
                BlockPos pos = new BlockPos(x, y, z);
                if (this.func_145831_w().func_175623_d(pos) || !this.isPlant(pos) || this.getMana() <= 5) continue;
                Block block = this.func_145831_w().func_180495_p(pos).func_177230_c();
                this.addMana(-5);
                this.func_145831_w().func_205220_G_().func_205360_a(pos, (Object)block, 1);
                if (((Boolean)ConfigHandler.COMMON.blockBreakParticles.get()).booleanValue()) {
                    this.func_145831_w().func_217379_c(2005, pos, 6 + this.func_145831_w().field_73012_v.nextInt(4));
                }
                this.func_145831_w().func_184148_a(null, (double)x, (double)y, (double)z, ModSounds.agricarnation, SoundCategory.BLOCKS, 0.01f, 0.5f + (float)Math.random() * 0.5f);
                break;
            }
        }
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    private boolean isPlant(BlockPos pos) {
        BlockState state = this.func_145831_w().func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == Blocks.field_196658_i || BlockTags.field_206952_E.func_199685_a_((Object)block) || block instanceof BushBlock && !(block instanceof CropsBlock) && !(block instanceof SaplingBlock)) {
            return false;
        }
        Material mat = state.func_185904_a();
        return (mat == Material.field_151585_k || mat == Material.field_151570_A || mat == Material.field_151577_b || mat == Material.field_151584_j || mat == Material.field_151572_C) && block instanceof IGrowable && ((IGrowable)block).func_176473_a((IBlockReader)this.func_145831_w(), pos, this.func_145831_w().func_180495_p(pos), this.func_145831_w().field_72995_K);
    }

    @Override
    public int getColor() {
        return 9369640;
    }

    @Override
    public int getMaxMana() {
        return 200;
    }

    public int getRange() {
        return 5;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), this.getRange());
    }

    public static class Mini
    extends SubTileAgricarnation {
        @ObjectHolder(value="botania:agricarnation_chibi")
        public static TileEntityType<SubTileAgricarnation> TYPE;

        public Mini() {
            super(TYPE);
        }

        @Override
        public int getRange() {
            return 2;
        }
    }
}

