/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LazyLoadBase;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketHandler;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;

public class TileTerraPlate
extends TileMod
implements ISparkAttachable,
ITickableTileEntity {
    @ObjectHolder(value="botania:terra_plate")
    public static TileEntityType<TileTerraPlate> TYPE;
    public static final int MAX_MANA = 500000;
    public static final LazyLoadBase<IMultiblock> MULTIBLOCK;
    private static final String TAG_MANA = "mana";
    private int mana;

    public TileTerraPlate() {
        super(TYPE);
    }

    public void func_73660_a() {
        List<ItemEntity> items;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean removeMana = true;
        if (this.hasValidPlatform() && this.areItemsValid(items = this.getItems())) {
            removeMana = false;
            ISparkEntity spark = this.getAttachedSpark();
            if (spark != null) {
                SparkHelper.getSparksAround(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, spark.getNetwork()).filter(otherSpark -> spark != otherSpark && otherSpark.getAttachedTile() instanceof IManaPool).forEach(os -> os.registerTransfer(spark));
            }
            if (this.mana > 0) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
                PacketHandler.sendToNearby(this.field_145850_b, this.func_174877_v(), (Object)new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.TERRA_PLATE, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), new int[0]));
            }
            if (this.mana >= 500000) {
                ItemEntity item = items.get(0);
                for (ItemEntity otherItem : items) {
                    if (otherItem != item) {
                        otherItem.func_70106_y();
                        continue;
                    }
                    item.func_92058_a(new ItemStack((IItemProvider)ModItems.terrasteel));
                }
                this.field_145850_b.func_184148_a(null, item.field_70165_t, item.field_70163_u, item.field_70161_v, ModSounds.terrasteelCraft, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.mana = 0;
                this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
            }
        }
        if (removeMana) {
            this.recieveMana(-1000);
        }
    }

    private List<ItemEntity> getItems() {
        return this.field_145850_b.func_217357_a(ItemEntity.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)));
    }

    private boolean areItemsValid(List<ItemEntity> items) {
        if (items.size() != 3) {
            return false;
        }
        ItemStack ingot = ItemStack.field_190927_a;
        ItemStack pearl = ItemStack.field_190927_a;
        ItemStack diamond = ItemStack.field_190927_a;
        for (ItemEntity item : items) {
            ItemStack stack = item.func_92059_d();
            if (stack.func_190916_E() != 1) {
                return false;
            }
            if (stack.func_77973_b() == ModItems.manaSteel) {
                ingot = stack;
                continue;
            }
            if (stack.func_77973_b() == ModItems.manaPearl) {
                pearl = stack;
                continue;
            }
            if (stack.func_77973_b() == ModItems.manaDiamond) {
                diamond = stack;
                continue;
            }
            return false;
        }
        return !ingot.func_190926_b() && !pearl.func_190926_b() && !diamond.func_190926_b();
    }

    private boolean hasValidPlatform() {
        return ((IMultiblock)MULTIBLOCK.func_179281_c()).validate(this.field_145850_b, this.func_174877_v().func_177977_b()) != null;
    }

    @Override
    public void writePacketNBT(CompoundNBT cmp) {
        cmp.func_74768_a(TAG_MANA, this.mana);
    }

    @Override
    public void readPacketNBT(CompoundNBT cmp) {
        this.mana = cmp.func_74762_e(TAG_MANA);
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        return this.mana >= 500000;
    }

    @Override
    public void recieveMana(int mana) {
        this.mana = Math.max(0, Math.min(500000, this.mana + mana));
        this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
    }

    @Override
    public boolean canRecieveManaFromBursts() {
        return this.areItemsValid(this.getItems());
    }

    @Override
    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    @Override
    public void attachSpark(ISparkEntity entity) {
    }

    @Override
    public ISparkEntity getAttachedSpark() {
        List sparks = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(this.field_174879_c.func_177984_a(), this.field_174879_c.func_177984_a().func_177982_a(1, 1, 1)), (Predicate)Predicates.instanceOf(ISparkEntity.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ISparkEntity)e;
        }
        return null;
    }

    @Override
    public boolean areIncomingTranfersDone() {
        return !this.areItemsValid(this.getItems());
    }

    @Override
    public int getAvailableSpaceForMana() {
        return Math.max(0, 500000 - this.getCurrentMana());
    }

    static {
        MULTIBLOCK = new LazyLoadBase(() -> PatchouliAPI.instance.makeMultiblock((String[][])new String[][]{{"___", "_P_", "___"}, {"RLR", "L0L", "RLR"}}, new Object[]{Character.valueOf('P'), ModBlocks.terraPlate, Character.valueOf('R'), "#botania:terra_plate_base", Character.valueOf('0'), "#botania:terra_plate_base", Character.valueOf('L'), "#forge:storage_blocks/lapis"}));
    }
}

