/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.IBrewContainer;
import vazkii.botania.api.brew.IBrewItem;
import vazkii.botania.api.item.AccessoryRenderHelper;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class ItemBloodPendant
extends ItemBauble
implements IBrewContainer,
IBrewItem,
IManaUsingItem {
    private static final String TAG_BREW_KEY = "brewKey";

    public ItemBloodPendant(Item.Properties props) {
        super(props);
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> list) {
        super.func_150895_a(tab, list);
        if (this.func_194125_a(tab)) {
            for (String s : BotaniaAPI.brewMap.keySet()) {
                ItemStack brewStack = this.getItemForBrew(BotaniaAPI.brewMap.get(s), new ItemStack((IItemProvider)this));
                if (brewStack.func_190926_b()) continue;
                list.add((Object)brewStack);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addHiddenTooltip(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag adv) {
        super.addHiddenTooltip(stack, world, list, adv);
        Brew brew = this.getBrew(stack);
        if (brew == BotaniaAPI.fallbackBrew) {
            list.add(new TranslationTextComponent("botaniamisc.notInfused", new Object[0]).func_211708_a(TextFormatting.LIGHT_PURPLE));
            return;
        }
        list.add(new TranslationTextComponent("botaniamisc.brewOf", new Object[]{I18n.func_135052_a((String)brew.getUnlocalizedName(stack), (Object[])new Object[0])}).func_211708_a(TextFormatting.LIGHT_PURPLE));
        for (EffectInstance effect : brew.getPotionEffects(stack)) {
            TextFormatting format = effect.func_188419_a().field_220305_b.func_220306_a();
            TranslationTextComponent cmp = new TranslationTextComponent(effect.func_76453_d(), new Object[0]);
            if (effect.func_76458_c() > 0) {
                cmp.func_150258_a(" ");
                cmp.func_150257_a((ITextComponent)new TranslationTextComponent("botania.roman" + (effect.func_76458_c() + 1), new Object[0]));
            }
            list.add(cmp.func_211708_a(format));
        }
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity player) {
        Brew brew = ((IBrewItem)stack.func_77973_b()).getBrew(stack);
        if (brew != BotaniaAPI.fallbackBrew && player instanceof PlayerEntity && !player.field_70170_p.field_72995_K) {
            boolean doRand;
            PlayerEntity eplayer = (PlayerEntity)player;
            EffectInstance effect = brew.getPotionEffects(stack).get(0);
            float cost = (float)brew.getManaCost(stack) / (float)effect.func_76459_b() / (float)(1 + effect.func_76458_c()) * 2.5f;
            boolean bl = doRand = cost < 1.0f;
            if (ManaItemHandler.requestManaExact(stack, eplayer, (int)Math.ceil(cost), false)) {
                boolean nightVision;
                EffectInstance currentEffect = player.func_70660_b(effect.func_188419_a());
                boolean bl2 = nightVision = effect.func_188419_a() == Effects.field_76439_r;
                if (currentEffect == null || currentEffect.func_76459_b() < (nightVision ? 305 : 3)) {
                    EffectInstance applyEffect = new EffectInstance(effect.func_188419_a(), nightVision ? 385 : 80, effect.func_76458_c(), true, true);
                    player.func_195064_c(applyEffect);
                }
                if (!doRand || Math.random() < (double)cost) {
                    ManaItemHandler.requestManaExact(stack, eplayer, (int)Math.ceil(cost), true);
                }
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doRender(ItemStack stack, LivingEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        AccessoryRenderHelper.rotateIfSneaking(player);
        boolean armor = !player.func_184582_a(EquipmentSlotType.CHEST).func_190926_b();
        GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.translatef((float)-0.26f, (float)-0.4f, (float)(armor ? 0.2f : 0.15f));
        GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
        for (TextureAtlasSprite icon : new TextureAtlasSprite[]{MiscellaneousIcons.INSTANCE.bloodPendantChain, MiscellaneousIcons.INSTANCE.bloodPendantGem}) {
            float f = icon.func_94209_e();
            float f1 = icon.func_94212_f();
            float f2 = icon.func_94206_g();
            float f3 = icon.func_94210_h();
            IconHelper.renderIconIn3D(Tessellator.func_178181_a(), f1, f2, f, f3, icon.func_94211_a(), icon.func_94216_b(), 0.03125f);
            Color color = new Color(Minecraft.func_71410_x().getItemColors().func_186728_a(stack, 1));
            GlStateManager.color3f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
            int light = 0xF000F0;
            int lightmapX = light % 65536;
            int lightmapY = light / 65536;
            GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)lightmapX, (float)lightmapY);
        }
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public Brew getBrew(ItemStack stack) {
        String key = ItemNBTHelper.getString(stack, TAG_BREW_KEY, "");
        return BotaniaAPI.getBrewFromKey(key);
    }

    public static void setBrew(ItemStack stack, Brew brew) {
        ItemBloodPendant.setBrew(stack, brew.getKey());
    }

    public static void setBrew(ItemStack stack, String brew) {
        ItemNBTHelper.setString(stack, TAG_BREW_KEY, brew);
    }

    @Override
    public ItemStack getItemForBrew(Brew brew, ItemStack stack) {
        if (!brew.canInfuseBloodPendant() || brew.getPotionEffects(stack).size() != 1 || brew.getPotionEffects(stack).get(0).func_188419_a().func_76403_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack brewStack = new ItemStack((IItemProvider)this);
        ItemBloodPendant.setBrew(brewStack, brew);
        return brewStack;
    }

    @Override
    public int getManaCost(Brew brew, ItemStack stack) {
        return brew.getManaCost() * 10;
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return this.getBrew(stack) != BotaniaAPI.fallbackBrew;
    }
}

