/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import vazkii.botania.api.item.AccessoryRenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.model.ModelCloak;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class ItemHolyCloak
extends ItemBauble {
    private static final ResourceLocation texture = new ResourceLocation("botania:textures/model/cloak_holy.png");
    private static final ResourceLocation textureGlow = new ResourceLocation("botania:textures/model/cloak_holy_glow.png");
    @OnlyIn(value=Dist.CLIENT)
    private static ModelCloak model;
    private static final String TAG_COOLDOWN = "cooldown";
    private static final String TAG_IN_EFFECT = "inEffect";

    public ItemHolyCloak(Item.Properties props) {
        super(props);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerDamage);
    }

    private void onPlayerDamage(LivingHurtEvent event) {
        PlayerEntity player;
        ItemStack stack;
        if (event.getEntityLiving() instanceof PlayerEntity && !event.getSource().func_76357_e() && !(stack = EquipmentHandler.findOrEmpty(this, (LivingEntity)(player = (PlayerEntity)event.getEntityLiving()))).func_190926_b() && !ItemHolyCloak.isInEffect(stack)) {
            ItemHolyCloak cloak = (ItemHolyCloak)stack.func_77973_b();
            int cooldown = ItemHolyCloak.getCooldown(stack);
            ItemHolyCloak.setInEffect(stack, true);
            if (cooldown == 0 && cloak.effectOnDamage(event, player, stack)) {
                ItemHolyCloak.setCooldown(stack, cloak.getCooldownTime(stack));
            }
            ItemHolyCloak.setInEffect(stack, false);
        }
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity living) {
        int cooldown = ItemHolyCloak.getCooldown(stack);
        if (cooldown > 0) {
            ItemHolyCloak.setCooldown(stack, cooldown - 1);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doRender(ItemStack stack, LivingEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        ItemHolyCloak item = (ItemHolyCloak)stack.func_77973_b();
        AccessoryRenderHelper.rotateIfSneaking(player);
        boolean armor = !player.func_184582_a(EquipmentSlotType.CHEST).func_190926_b();
        GlStateManager.translatef((float)0.0f, (float)(armor ? -0.07f : -0.01f), (float)0.0f);
        float s = 0.0625f;
        GlStateManager.scalef((float)s, (float)s, (float)s);
        if (model == null) {
            model = new ModelCloak();
        }
        GlStateManager.enableLighting();
        GlStateManager.enableRescaleNormal();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(item.getCloakTexture());
        model.render(1.0f);
        int light = 0xF000F0;
        int lightmapX = light % 65536;
        int lightmapY = light / 65536;
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)lightmapX, (float)lightmapY);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(item.getCloakGlowTexture());
        model.render(1.0f);
    }

    public boolean effectOnDamage(LivingHurtEvent event, PlayerEntity player, ItemStack stack) {
        if (!event.getSource().func_82725_o()) {
            event.setCanceled(true);
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSounds.holyCloak, SoundCategory.PLAYERS, 1.0f, 1.0f);
            for (int i = 0; i < 30; ++i) {
                double x = player.field_70165_t + Math.random() * (double)player.func_213311_cf() * 2.0 - (double)player.func_213311_cf();
                double y = player.field_70163_u + Math.random() * (double)player.func_213302_cg();
                double z = player.field_70161_v + Math.random() * (double)player.func_213311_cf() * 2.0 - (double)player.func_213311_cf();
                boolean yellow = Math.random() > 0.5;
                float r = yellow ? 1.0f : 0.3f;
                float g = yellow ? 1.0f : 0.3f;
                float b = yellow ? 0.3f : 1.0f;
                SparkleParticleData data = SparkleParticleData.sparkle(0.8f + (float)Math.random() * 0.4f, r, g, b, 3);
                player.field_70170_p.func_195594_a((IParticleData)data, x, y, z, 0.0, 0.0, 0.0);
            }
            return true;
        }
        return false;
    }

    public int getCooldownTime(ItemStack stack) {
        return 200;
    }

    public static int getCooldown(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_COOLDOWN, 0);
    }

    public static void setCooldown(ItemStack stack, int cooldown) {
        ItemNBTHelper.setInt(stack, TAG_COOLDOWN, cooldown);
    }

    public static boolean isInEffect(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_IN_EFFECT, false);
    }

    public static void setInEffect(ItemStack stack, boolean effect) {
        ItemNBTHelper.setBoolean(stack, TAG_IN_EFFECT, effect);
    }

    @OnlyIn(value=Dist.CLIENT)
    ResourceLocation getCloakTexture() {
        return texture;
    }

    @OnlyIn(value=Dist.CLIENT)
    ResourceLocation getCloakGlowTexture() {
        return textureGlow;
    }
}

