/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.ItemMod;

public class ItemDirtRod
extends ItemMod
implements IManaUsingItem,
IBlockProvider,
IAvatarWieldable {
    private static final ResourceLocation avatarOverlay = new ResourceLocation("botania:textures/model/avatar_dirt.png");
    static final int COST = 75;

    public ItemDirtRod(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        return ItemDirtRod.place(ctx, Blocks.field_150346_d, 75, 0.35f, 0.2f, 0.05f);
    }

    public static ActionResultType place(ItemUseContext ctx, Block block, int cost, float r, float g, float b) {
        PlayerEntity player = ctx.func_195999_j();
        ItemStack stack = ctx.func_195996_i();
        World world = ctx.func_195991_k();
        Direction side = ctx.func_196000_l();
        BlockPos pos = ctx.func_195995_a();
        if (player != null && ManaItemHandler.requestManaExactForTool(stack, player, cost, false)) {
            int entities = world.func_217357_a(LivingEntity.class, new AxisAlignedBB(pos.func_177972_a(side), pos.func_177972_a(side).func_177982_a(1, 1, 1))).size();
            if (entities == 0) {
                ItemStack stackToPlace = new ItemStack((IItemProvider)block);
                PlayerHelper.substituteUse(ctx, stackToPlace);
                if (stackToPlace.func_190926_b()) {
                    ManaItemHandler.requestManaExactForTool(stack, player, cost, true);
                    SparkleParticleData data = SparkleParticleData.sparkle(1.0f, r, g, b, 5);
                    for (int i = 0; i < 6; ++i) {
                        world.func_195594_a((IParticleData)data, (double)(pos.func_177958_n() + side.func_82601_c()) + Math.random(), (double)(pos.func_177956_o() + side.func_96559_d()) + Math.random(), (double)(pos.func_177952_p() + side.func_82599_e()) + Math.random(), 0.0, 0.0, 0.0);
                    }
                    return ActionResultType.SUCCESS;
                }
            }
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public boolean provideBlock(PlayerEntity player, ItemStack requestor, ItemStack stack, Block block, boolean doit) {
        if (block == Blocks.field_150346_d) {
            return !doit || ManaItemHandler.requestManaExactForTool(requestor, player, 75, true);
        }
        return false;
    }

    @Override
    public int getBlockCount(PlayerEntity player, ItemStack requestor, ItemStack stack, Block block) {
        if (block == Blocks.field_150346_d) {
            return -1;
        }
        return 0;
    }

    @Override
    public void onAvatarUpdate(IAvatarTile tile, ItemStack stack) {
        BlockPos pos;
        BlockState state;
        TileEntity te = (TileEntity)tile;
        World world = te.func_145831_w();
        if (!world.field_72995_K && tile.getCurrentMana() >= 75 && tile.getElapsedFunctionalTicks() % 4 == 0 && world.field_73012_v.nextInt(8) == 0 && tile.isEnabled() && (state = world.func_180495_p(pos = ((TileEntity)tile).func_174877_v().func_177972_a(tile.getAvatarFacing()))).func_177230_c().isAir(state, (IBlockReader)world, pos)) {
            world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
            world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)Blocks.field_150346_d.func_176223_P()));
            tile.recieveMana(-75);
        }
    }

    @Override
    public ResourceLocation getOverlayResource(IAvatarTile tile, ItemStack stack) {
        return avatarOverlay;
    }
}

