/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.world;

import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileManaFlame;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.loot.LootHandler;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.common.world.WorldTypeSkyblock;

public final class SkyblockWorldEvents {
    private static final String TAG_MADE_ISLAND = "Botania-MadeIsland";
    private static final String TAG_HAS_OWN_ISLAND = "Botania-HasOwnIsland";
    private static final String TAG_ISLAND_X = "Botania-IslandX";
    private static final String TAG_ISLAND_Y = "Botania-IslandY";
    private static final String TAG_ISLAND_Z = "Botania-IslandZ";
    private static final ResourceLocation TARGET_LOOT_TABLE = new ResourceLocation("blocks/grass");

    private SkyblockWorldEvents() {
    }

    @SubscribeEvent
    public static void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && !event.getEntityLiving().field_70170_p.field_72995_K) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            CompoundNBT data = player.getPersistentData();
            if (!data.func_74764_b("PlayerPersisted")) {
                data.func_218657_a("PlayerPersisted", (INBT)new CompoundNBT());
            }
            CompoundNBT persist = data.func_74775_l("PlayerPersisted");
            if (player.field_70173_aa > 3 && !persist.func_74767_n(TAG_MADE_ISLAND)) {
                ServerWorld overworld = ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.field_223227_a_);
                World world = player.field_70170_p;
                if (WorldTypeSkyblock.isWorldSkyblock(world)) {
                    BlockPos coords = world.func_175694_M();
                    if (coords.func_177956_o() <= 0) {
                        coords = new BlockPos(coords.func_177958_n(), 64, coords.func_177952_p());
                        world.func_175652_B(coords);
                    }
                    if (world.func_180495_p(coords.func_177979_c(4)).func_177230_c() != Blocks.field_150357_h && world == overworld) {
                        SkyblockWorldEvents.spawnPlayer(player, coords, false);
                    }
                }
                persist.func_74757_a(TAG_MADE_ISLAND, true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (Botania.gardenOfGlassLoaded) {
            BlockRayTraceResult rtr;
            ItemStack equipped = event.getItemStack();
            PlayerEntity player = event.getPlayer();
            if (equipped.func_190926_b() && player.func_70093_af()) {
                BlockState state = event.getWorld().func_180495_p(event.getPos());
                Block block = state.func_177230_c();
                if (ModTags.Blocks.PEBBLE_SOURCES.func_199685_a_((Object)block)) {
                    SoundType st = state.getSoundType((IWorldReader)event.getWorld(), event.getPos(), (Entity)player);
                    player.func_184185_a(st.func_185845_c(), st.func_185843_a() * 0.4f, st.func_185847_b() + (float)(Math.random() * 0.2 - 0.1));
                    if (event.getWorld().field_72995_K) {
                        player.func_184609_a(event.getHand());
                    } else if (Math.random() < 0.8) {
                        player.func_71019_a(new ItemStack((IItemProvider)ModItems.pebble), false);
                    }
                    event.setCanceled(true);
                    event.setCancellationResult(ActionResultType.SUCCESS);
                }
            } else if (!equipped.func_190926_b() && equipped.func_77973_b() == Items.field_151054_z && (rtr = ToolCommons.raytraceFromEntity(event.getWorld(), player, RayTraceContext.FluidMode.SOURCE_ONLY, 4.5)).func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockPos pos = rtr.func_216350_a();
                if (event.getWorld().func_180495_p(pos).func_185904_a() == Material.field_151586_h) {
                    if (!event.getWorld().field_72995_K) {
                        equipped.func_190918_g(1);
                        if (equipped.func_190926_b()) {
                            player.func_184611_a(event.getHand(), new ItemStack((IItemProvider)ModItems.waterBowl));
                        } else {
                            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)ModItems.waterBowl));
                        }
                    }
                    event.setCanceled(true);
                    event.setCancellationResult(ActionResultType.SUCCESS);
                }
            }
        }
    }

    @SubscribeEvent
    public static void loadLoot(LootTableLoadEvent event) {
        if (Botania.gardenOfGlassLoaded && event.getName().equals((Object)TARGET_LOOT_TABLE)) {
            event.getTable().addPool(LootHandler.getInjectPool("gog_grass"));
        }
    }

    public static void spawnPlayer(PlayerEntity player, BlockPos pos, boolean fabricated) {
        CompoundNBT data = player.getPersistentData();
        if (!data.func_74764_b("PlayerPersisted")) {
            data.func_218657_a("PlayerPersisted", (INBT)new CompoundNBT());
        }
        CompoundNBT persist = data.func_74775_l("PlayerPersisted");
        boolean test = false;
        if (!persist.func_74767_n(TAG_HAS_OWN_ISLAND)) {
            SkyblockWorldEvents.createSkyblock(player.field_70170_p, pos);
            if (player instanceof ServerPlayerEntity) {
                ServerPlayerEntity pmp = (ServerPlayerEntity)player;
                pmp.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.6, (double)pos.func_177952_p() + 0.5);
                pmp.setSpawnPoint(pos, true, player.field_70170_p.func_201675_m().func_186058_p());
                if (((Boolean)ConfigHandler.COMMON.gogSpawnWithLexicon.get()).booleanValue()) {
                    player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)ModItems.lexicon));
                }
            }
            if (fabricated) {
                persist.func_74757_a(TAG_HAS_OWN_ISLAND, true);
                persist.func_74780_a(TAG_ISLAND_X, player.field_70165_t);
                persist.func_74780_a(TAG_ISLAND_Y, player.field_70163_u);
                persist.func_74780_a(TAG_ISLAND_Z, player.field_70161_v);
            }
        } else {
            double posX = persist.func_74769_h(TAG_ISLAND_X);
            double posY = persist.func_74769_h(TAG_ISLAND_Y);
            double posZ = persist.func_74769_h(TAG_ISLAND_Z);
            if (player instanceof ServerPlayerEntity) {
                ServerPlayerEntity pmp = (ServerPlayerEntity)player;
                pmp.func_70634_a(posX, posY, posZ);
            }
        }
    }

    public static void createSkyblock(World world, BlockPos pos) {
        int[][] rootPositions;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 3; ++k) {
                    world.func_175656_a(pos.func_177982_a(-1 + i, -1 - j, -1 + k), j == 0 ? Blocks.field_196658_i.func_176223_P() : Blocks.field_150346_d.func_176223_P());
                }
            }
        }
        world.func_175656_a(pos.func_177982_a(-1, -2, 0), Blocks.field_150355_j.func_176223_P());
        world.func_175656_a(pos.func_177982_a(1, 2, 1), ModBlocks.manaFlame.func_176223_P());
        ((TileManaFlame)world.func_175625_s(pos.func_177982_a(1, 2, 1))).setColor(new Color(70 + world.field_73012_v.nextInt(185), 70 + world.field_73012_v.nextInt(185), 70 + world.field_73012_v.nextInt(185)).getRGB());
        for (int[] root : rootPositions = new int[][]{{-1, -3, -1}, {-2, -4, -1}, {-2, -4, -2}, {1, -4, -1}, {1, -5, -1}, {2, -5, -1}, {2, -6, 0}, {0, -4, 2}, {0, -5, 2}, {0, -5, 3}, {0, -6, 3}}) {
            world.func_175656_a(pos.func_177982_a(root[0], root[1], root[2]), ModBlocks.root.func_176223_P());
        }
        world.func_175656_a(pos.func_177979_c(4), Blocks.field_150357_h.func_176223_P());
    }
}

