/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.common.network.PacketHandler;
import vazkii.botania.common.network.PacketUpdateItemsRemaining;

public final class ItemsRemainingRenderHandler {
    private static final int maxTicks = 30;
    private static final int leaveTicks = 20;
    private static ItemStack stack = ItemStack.field_190927_a;
    @Nullable
    private static ITextComponent customString;
    private static int ticks;
    private static int count;

    @OnlyIn(value=Dist.CLIENT)
    public static void render(MatrixStack ms, float partTicks) {
        if (ticks > 0 && !stack.func_190926_b()) {
            int pos = 30 - ticks;
            Minecraft mc = Minecraft.func_71410_x();
            int x = mc.func_228018_at_().func_198107_o() / 2 + 10 + Math.max(0, pos - 20);
            int y = mc.func_228018_at_().func_198087_p() / 2;
            int start = 10;
            float alpha = (float)ticks + partTicks > (float)start ? 1.0f : ((float)ticks + partTicks) / (float)start;
            int xp = x + (int)(16.0f * (1.0f - alpha));
            ms.func_227860_a_();
            ms.func_227861_a_((double)xp, (double)y, 0.0);
            ms.func_227862_a_(alpha, 1.0f, 1.0f);
            RenderSystem.pushMatrix();
            RenderSystem.multMatrix((Matrix4f)ms.func_227866_c_().func_227870_a_());
            mc.func_175599_af().func_180450_b(stack, 0, 0);
            RenderSystem.popMatrix();
            ms.func_227865_b_();
            ITextComponent text = StringTextComponent.field_240750_d_;
            if (customString == null) {
                if (!stack.func_190926_b()) {
                    text = stack.func_200301_q().func_230532_e_().func_240699_a_(TextFormatting.GREEN);
                    if (count >= 0) {
                        int max = stack.func_77976_d();
                        int stacks = count / max;
                        int rem = count % max;
                        if (stacks == 0) {
                            text = new StringTextComponent(Integer.toString(count));
                        } else {
                            IFormattableTextComponent stacksText = new StringTextComponent(Integer.toString(stacks)).func_240699_a_(TextFormatting.AQUA);
                            IFormattableTextComponent maxText = new StringTextComponent(Integer.toString(max)).func_240699_a_(TextFormatting.GRAY);
                            IFormattableTextComponent remText = new StringTextComponent(Integer.toString(rem)).func_240699_a_(TextFormatting.YELLOW);
                            text = new StringTextComponent(count + " (").func_230529_a_((ITextComponent)stacksText).func_240702_b_("*").func_230529_a_((ITextComponent)maxText).func_240702_b_("+").func_230529_a_((ITextComponent)remText).func_240702_b_(")");
                        }
                    } else if (count == -1) {
                        text = new StringTextComponent("\u221e");
                    }
                }
            } else {
                text = customString;
            }
            int color = 0xFFFFFF | (int)(alpha * 255.0f) << 24;
            mc.field_71466_p.func_238407_a_(ms, (ITextProperties)text, (float)(x + 20), (float)(y + 6), color);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void tick() {
        if (ticks > 0) {
            --ticks;
        }
    }

    public static void send(PlayerEntity player, ItemStack stack, int count) {
        ItemsRemainingRenderHandler.send(player, stack, count, null);
    }

    public static void set(ItemStack stack, int count, @Nullable ITextComponent str) {
        ItemsRemainingRenderHandler.stack = stack;
        ItemsRemainingRenderHandler.count = count;
        customString = str;
        ticks = stack.func_190926_b() ? 0 : 30;
    }

    public static void send(PlayerEntity entity, ItemStack stack, int count, @Nullable ITextComponent str) {
        PacketHandler.sendTo((ServerPlayerEntity)entity, new PacketUpdateItemsRemaining(stack, count, str));
    }

    public static void send(PlayerEntity player, ItemStack displayStack, Pattern pattern) {
        int count = 0;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || !pattern.matcher(stack.func_77977_a()).find()) continue;
            count += stack.func_190916_E();
        }
        ItemsRemainingRenderHandler.send(player, displayStack, count, null);
    }
}

