/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.runicaltar;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector2f;
import vazkii.botania.api.recipe.IRuneAltarRecipe;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.client.integration.jei.JEIBotaniaPlugin;
import vazkii.botania.client.integration.jei.petalapothecary.PetalApothecaryRecipeCategory;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class RunicAltarRecipeCategory
implements IRecipeCategory<IRuneAltarRecipe> {
    public static final ResourceLocation UID = ResourceLocationHelper.prefix("runic_altar");
    private final IDrawable background;
    private final String localizedName;
    private final IDrawable overlay;
    private final IDrawable icon;

    public RunicAltarRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(150, 110);
        this.localizedName = I18n.func_135052_a((String)"botania.nei.runicAltar", (Object[])new Object[0]);
        this.overlay = guiHelper.createDrawable(ResourceLocationHelper.prefix("textures/gui/petal_overlay.png"), 0, 0, 150, 110);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.runeAltar));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends IRuneAltarRecipe> getRecipeClass() {
        return IRuneAltarRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(IRuneAltarRecipe recipe, IIngredients iIngredients) {
        ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
        for (Ingredient ingr : recipe.func_192400_c()) {
            list.add(Arrays.asList(ingr.func_193365_a()));
        }
        iIngredients.setInputLists(VanillaTypes.ITEM, list);
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void draw(IRuneAltarRecipe recipe, MatrixStack ms, double mouseX, double mouseY) {
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        this.overlay.draw(ms);
        HUDHandler.renderManaBar(ms, 28, 105, 255, 0.75f, recipe.getManaUsage(), 100000);
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRuneAltarRecipe recipe, @Nonnull IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 64, 52);
        recipeLayout.getItemStacks().set(0, new ItemStack((IItemProvider)ModBlocks.runeAltar));
        int index = 1;
        double angleBetweenEach = 360.0 / (double)ingredients.getInputs(VanillaTypes.ITEM).size();
        Vector2f point = new Vector2f(64.0f, 20.0f);
        Vector2f center = new Vector2f(64.0f, 52.0f);
        for (List o : ingredients.getInputs(VanillaTypes.ITEM)) {
            recipeLayout.getItemStacks().init(index, true, (int)point.field_189982_i, (int)point.field_189983_j);
            recipeLayout.getItemStacks().set(index, o);
            ++index;
            point = PetalApothecaryRecipeCategory.rotatePointAbout(point, center, angleBetweenEach);
        }
        recipeLayout.getItemStacks().init(index, false, 103, 17);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        JEIBotaniaPlugin.addDefaultRecipeIdTooltip(recipeLayout.getItemStacks(), index, recipe.func_199560_c());
    }
}

