/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.model.ModelHourglass;
import vazkii.botania.common.block.tile.TileHourglass;

public class RenderTileHourglass
extends TileEntityRenderer<TileHourglass> {
    final ResourceLocation texture = new ResourceLocation("botania:textures/model/hourglass.png");
    final ModelHourglass model = new ModelHourglass();

    public RenderTileHourglass(TileEntityRendererDispatcher manager) {
        super(manager);
    }

    public void render(@Nullable TileHourglass hourglass, float ticks, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
        float rot;
        int wtime;
        ms.func_227860_a_();
        boolean hasWorld = hourglass != null && hourglass.func_145831_w() != null;
        int n = wtime = !hasWorld ? 0 : ClientTickHandler.ticksInGame;
        if (wtime != 0) {
            wtime += new Random(hourglass.func_174877_v().hashCode()).nextInt(360);
        }
        float time = wtime == 0 ? 0.0f : (float)wtime + ticks;
        float x = 0.5f + (float)Math.cos(time * 0.05f) * 0.025f;
        float y = 0.55f + (float)(Math.sin(time * 0.04f) + 1.0) * 0.05f;
        float z = 0.5f + (float)Math.sin(time * 0.05f) * 0.025f;
        ItemStack stack = hasWorld ? hourglass.getItemHandler().func_70301_a(0) : ItemStack.field_190927_a;
        float activeFraction = stack.func_190926_b() ? 0.0f : hourglass.lastFraction + (hourglass.timeFraction - hourglass.lastFraction) * ticks;
        float fract1 = stack.func_190926_b() ? 0.0f : activeFraction;
        float fract2 = stack.func_190926_b() ? 0.0f : 1.0f - activeFraction;
        ms.func_227861_a_((double)x, (double)y, (double)z);
        float f = rot = hasWorld && hourglass.flip ? 180.0f : 1.0f;
        if (hasWorld && hourglass.flipTicks > 0) {
            rot += ((float)hourglass.flipTicks - ticks) * 45.0f;
        }
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(rot));
        ms.func_227862_a_(1.0f, -1.0f, -1.0f);
        int color = hasWorld ? hourglass.getColor() : 0;
        float r = (float)(color >> 16) / 255.0f;
        float g = (float)(color >> 8) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        IVertexBuilder buffer = buffers.getBuffer(this.model.func_228282_a_(this.texture));
        this.model.render(ms, buffer, light, overlay, r, g, b, 1.0f, fract1, fract2, hasWorld && hourglass.flip);
        ms.func_227865_b_();
    }
}

