/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.model.ModelPylonGaia;
import vazkii.botania.client.model.ModelPylonMana;
import vazkii.botania.client.model.ModelPylonNatura;
import vazkii.botania.common.block.BlockPylon;
import vazkii.botania.common.block.tile.TilePylon;

public class RenderTilePylon
extends TileEntityRenderer<TilePylon> {
    public static final ResourceLocation MANA_TEXTURE = new ResourceLocation("botania:textures/model/pylon_mana.png");
    public static final ResourceLocation NATURA_TEXTURE = new ResourceLocation("botania:textures/model/pylon_natura.png");
    public static final ResourceLocation GAIA_TEXTURE = new ResourceLocation("botania:textures/model/pylon_gaia.png");
    private final ModelPylonMana manaModel = new ModelPylonMana();
    private final ModelPylonNatura naturaModel = new ModelPylonNatura();
    private final ModelPylonGaia gaiaModel = new ModelPylonGaia();
    private static BlockPylon.Variant forceVariant = BlockPylon.Variant.MANA;
    private static ItemCameraTransforms.TransformType forceTransform = ItemCameraTransforms.TransformType.NONE;

    public RenderTilePylon(TileEntityRendererDispatcher manager) {
        super(manager);
    }

    public void render(@Nonnull TilePylon pylon, float pticks, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
        this.renderPylon(pylon, pticks, ms, buffers, light, overlay);
    }

    private void renderPylon(@Nullable TilePylon pylon, float pticks, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
        RenderType shaderLayer;
        ResourceLocation texture;
        Model model;
        boolean renderingItem = pylon == null;
        boolean direct = renderingItem && (forceTransform == ItemCameraTransforms.TransformType.GUI || forceTransform.func_241716_a_());
        BlockPylon.Variant type = renderingItem ? forceVariant : ((BlockPylon)pylon.func_195044_w().func_177230_c()).variant;
        switch (type) {
            default: {
                model = this.manaModel;
                texture = MANA_TEXTURE;
                shaderLayer = direct ? RenderHelper.MANA_PYLON_GLOW_DIRECT : RenderHelper.MANA_PYLON_GLOW;
                break;
            }
            case NATURA: {
                model = this.naturaModel;
                texture = NATURA_TEXTURE;
                shaderLayer = direct ? RenderHelper.NATURA_PYLON_GLOW_DIRECT : RenderHelper.NATURA_PYLON_GLOW;
                break;
            }
            case GAIA: {
                model = this.gaiaModel;
                texture = GAIA_TEXTURE;
                shaderLayer = direct ? RenderHelper.GAIA_PYLON_GLOW_DIRECT : RenderHelper.GAIA_PYLON_GLOW;
            }
        }
        ms.func_227860_a_();
        float worldTime = (float)ClientTickHandler.ticksInGame + pticks;
        worldTime += pylon == null ? 0.0f : (float)new Random(pylon.func_174877_v().hashCode()).nextInt(360);
        ms.func_227861_a_(0.0, pylon == null ? 1.35 : 1.5, 0.0);
        ms.func_227862_a_(1.0f, -1.0f, -1.0f);
        ms.func_227860_a_();
        ms.func_227861_a_(0.5, 0.0, -0.5);
        if (pylon != null) {
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(worldTime * 1.5f));
        }
        RenderType layer = RenderType.func_228644_e_((ResourceLocation)texture);
        IVertexBuilder buffer = buffers.getBuffer(layer);
        model.renderRing(ms, buffer, light, overlay);
        if (pylon != null) {
            ms.func_227861_a_(0.0, Math.sin((double)worldTime / 20.0) / 20.0 - 0.025, 0.0);
        }
        ms.func_227865_b_();
        ms.func_227860_a_();
        if (pylon != null) {
            ms.func_227861_a_(0.0, Math.sin((double)worldTime / 20.0) / 17.5, 0.0);
        }
        ms.func_227861_a_(0.5, 0.0, -0.5);
        if (pylon != null) {
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-worldTime));
        }
        buffer = buffers.getBuffer(shaderLayer);
        model.renderCrystal(ms, buffer, light, overlay);
        ms.func_227865_b_();
        ms.func_227865_b_();
    }

    public static class TEISR
    extends ItemStackTileEntityRenderer {
        private static final LazyValue<TilePylon> DUMMY = new LazyValue(TilePylon::new);

        public void func_239207_a_(ItemStack stack, ItemCameraTransforms.TransformType type, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
            if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockPylon) {
                forceVariant = ((BlockPylon)Block.func_149634_a((Item)stack.func_77973_b())).variant;
                forceTransform = type;
                TileEntityRenderer r = TileEntityRendererDispatcher.field_147556_a.func_147547_b((TileEntity)DUMMY.func_179281_c());
                ((RenderTilePylon)r).renderPylon(null, 0.0f, ms, buffers, light, overlay);
            }
        }
    }
}

