/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.StemBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.ToolType;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BlockMod;

public class BlockAltGrass
extends BlockMod {
    private final Variant variant;

    public BlockAltGrass(Variant v, AbstractBlock.Properties builder) {
        super(builder);
        this.variant = v;
    }

    public boolean isToolEffective(BlockState state, ToolType tool) {
        return tool.equals(ToolType.SHOVEL);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack held = player.func_184586_b(hand);
        if (held.func_77973_b() instanceof HoeItem && world.func_175623_d(pos.func_177984_a())) {
            held.func_222118_a(1, (LivingEntity)player, e -> e.func_213334_d(hand));
            world.func_175656_a(pos, Blocks.field_150458_ak.func_176223_P());
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (!world.field_72995_K && state.func_177230_c() == this && world.func_201696_r(pos.func_177984_a()) >= 9) {
            for (int l = 0; l < 4; ++l) {
                BlockPos pos1 = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                BlockPos pos1up = pos1.func_177984_a();
                if (world.func_180495_p(pos1).func_177230_c() != Blocks.field_150346_d || world.func_201696_r(pos1up) < 4 || world.func_180495_p(pos1up).func_200016_a((IBlockReader)world, pos1up) > 2) continue;
                world.func_175656_a(pos1, this.func_176223_P());
            }
        }
    }

    public boolean canSustainPlant(@Nonnull BlockState state, @Nonnull IBlockReader world, BlockPos pos, @Nonnull Direction direction, IPlantable plantable) {
        PlantType type = plantable.getPlantType(world, pos.func_177977_b());
        return type == PlantType.PLAINS || type == PlantType.BEACH || plantable instanceof StemBlock;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random r) {
        switch (this.variant) {
            case DRY: {
                break;
            }
            case GOLDEN: {
                break;
            }
            case VIVID: {
                break;
            }
            case SCORCHED: {
                if (r.nextInt(80) != 0) break;
                world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)((float)pos.func_177958_n() + r.nextFloat()), (double)pos.func_177956_o() + 1.1, (double)((float)pos.func_177952_p() + r.nextFloat()), 0.0, 0.0, 0.0);
                break;
            }
            case INFUSED: {
                if (r.nextInt(100) != 0) break;
                SparkleParticleData data = SparkleParticleData.sparkle(r.nextFloat() * 0.2f + 1.0f, 0.0f, 1.0f, 1.0f, 5);
                world.func_195594_a((IParticleData)data, (double)((float)pos.func_177958_n() + r.nextFloat()), (double)pos.func_177956_o() + 1.05, (double)((float)pos.func_177952_p() + r.nextFloat()), 0.0, 0.0, 0.0);
                break;
            }
            case MUTATED: {
                if (r.nextInt(100) != 0) break;
                if (r.nextInt(100) > 25) {
                    SparkleParticleData data = SparkleParticleData.sparkle(r.nextFloat() * 0.2f + 1.0f, 1.0f, 0.0f, 1.0f, 5);
                    world.func_195594_a((IParticleData)data, (double)((float)pos.func_177958_n() + r.nextFloat()), (double)pos.func_177956_o() + 1.05, (double)((float)pos.func_177952_p() + r.nextFloat()), 0.0, 0.0, 0.0);
                    break;
                }
                SparkleParticleData data = SparkleParticleData.sparkle(r.nextFloat() * 0.2f + 1.0f, 1.0f, 1.0f, 0.0f, 5);
                world.func_195594_a((IParticleData)data, (double)((float)pos.func_177958_n() + r.nextFloat()), (double)pos.func_177956_o() + 1.05, (double)((float)pos.func_177952_p() + r.nextFloat()), 0.0, 0.0, 0.0);
            }
        }
    }

    public static enum Variant {
        DRY,
        GOLDEN,
        VIVID,
        SCORCHED,
        INFUSED,
        MUTATED;

    }
}

