/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.IPetalApothecary;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileAltar;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.item.ModItems;

public class BlockAltar
extends BlockMod
implements ITileEntityProvider {
    public static final EnumProperty<IPetalApothecary.State> FLUID = EnumProperty.func_177709_a((String)"fluid", IPetalApothecary.State.class);
    private static final VoxelShape BASE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape MIDDLE = Block.func_208617_a((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    private static final VoxelShape TOP = Block.func_208617_a((double)2.0, (double)12.0, (double)2.0, (double)14.0, (double)20.0, (double)14.0);
    private static final VoxelShape TOP_CUTOUT = Block.func_208617_a((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)20.0, (double)13.0);
    private static final VoxelShape SHAPE = VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)BASE, (VoxelShape)MIDDLE), (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)TOP, (VoxelShape)TOP_CUTOUT, (IBooleanFunction)IBooleanFunction.field_223234_e_));
    public final Variant variant;

    protected BlockAltar(Variant v, AbstractBlock.Properties builder) {
        super(builder);
        this.variant = v;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(FLUID, (Comparable)((Object)IPetalApothecary.State.EMPTY)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FLUID});
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        TileAltar tile;
        if (!world.field_72995_K && entity instanceof ItemEntity && (tile = (TileAltar)world.func_175625_s(pos)).collideEntityItem((ItemEntity)entity)) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileAltar tile = (TileAltar)world.func_175625_s(pos);
        IPetalApothecary.State fluid = tile.getFluid();
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            vazkii.botania.common.core.helper.InventoryHelper.withdrawFromInventory(tile, player);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
            return ActionResultType.SUCCESS;
        }
        if (tile.isEmpty() && fluid == IPetalApothecary.State.WATER && stack.func_190926_b()) {
            tile.trySetLastRecipe(player);
            return ActionResultType.SUCCESS;
        }
        if (!stack.func_190926_b() && fluid != IPetalApothecary.State.EMPTY && this.isValidFluidContainerToFill(stack, tile.getFluid().asVanilla()) && !Botania.gardenOfGlassLoaded) {
            if (!player.field_71075_bZ.field_75098_d) {
                if (stack.func_190916_E() == 1) {
                    player.func_184611_a(hand, this.fill(tile.getFluid().asVanilla(), stack));
                } else {
                    player.field_71071_by.func_191975_a(player.field_70170_p, new ItemStack((IItemProvider)stack.func_77973_b()));
                    stack.func_190918_g(1);
                }
            }
            tile.setFluid(IPetalApothecary.State.EMPTY);
            world.func_72863_F().func_212863_j_().func_215568_a(pos);
            return ActionResultType.SUCCESS;
        }
        if (!stack.func_190926_b() && (this.isValidFluidContainerToDrain(stack, (Fluid)Fluids.field_204546_a) || stack.func_77973_b() == ModItems.waterRod && ManaItemHandler.instance().requestManaExact(stack, player, 75, false))) {
            if (tile.getFluid() == IPetalApothecary.State.EMPTY) {
                if (stack.func_77973_b() == ModItems.waterRod) {
                    ManaItemHandler.instance().requestManaExact(stack, player, 75, true);
                } else if (!player.field_71075_bZ.field_75098_d) {
                    player.func_184611_a(hand, this.drain((Fluid)Fluids.field_204546_a, stack));
                }
                tile.setFluid(IPetalApothecary.State.WATER);
            }
            return ActionResultType.SUCCESS;
        }
        if (!stack.func_190926_b() && this.isValidFluidContainerToDrain(stack, (Fluid)Fluids.field_204547_b)) {
            if (tile.getFluid() == IPetalApothecary.State.EMPTY) {
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_184611_a(hand, this.drain((Fluid)Fluids.field_204547_b, stack));
                }
                tile.setFluid(IPetalApothecary.State.LAVA);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_176224_k(World world, BlockPos pos) {
        BlockState state;
        if (world.field_73012_v.nextInt(20) == 1 && (state = world.func_180495_p(pos)).func_177229_b(FLUID) == IPetalApothecary.State.EMPTY) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a(FLUID, (Comparable)((Object)IPetalApothecary.State.WATER)));
        }
    }

    private boolean isValidFluidContainerToDrain(ItemStack stack, Fluid fluid) {
        if (stack.func_190926_b() || stack.func_190916_E() != 1) {
            return false;
        }
        return (Boolean)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(handler -> {
            FluidStack simulate = handler.drain(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.SIMULATE);
            return !simulate.isEmpty() && simulate.getFluid() == fluid && simulate.getAmount() == 1000;
        }).orElse((Object)false);
    }

    private ItemStack drain(Fluid fluid, ItemStack stack) {
        return (ItemStack)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(handler -> {
            handler.drain(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
            return handler.getContainer();
        }).orElse((Object)stack);
    }

    private boolean isValidFluidContainerToFill(ItemStack stack, Fluid fluid) {
        if (stack.func_190926_b()) {
            return false;
        }
        ItemStack container = stack;
        if (stack.func_190916_E() > 1) {
            container = new ItemStack((IItemProvider)stack.func_77973_b());
        }
        return (Boolean)container.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(handler -> {
            int amount = handler.fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.SIMULATE);
            return amount == 1000;
        }).orElse((Object)false);
    }

    private ItemStack fill(Fluid fluid, ItemStack stack) {
        return (ItemStack)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(handler -> {
            handler.fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
            return handler.getContainer();
        }).orElse((Object)stack);
    }

    @Nonnull
    public TileEntity func_196283_a_(@Nonnull IBlockReader world) {
        return new TileAltar();
    }

    public void func_196243_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileSimpleInventory inv = (TileSimpleInventory)world.func_175625_s(pos);
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)inv.getItemHandler());
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        return state.func_177229_b(FLUID) == IPetalApothecary.State.WATER ? 15 : 0;
    }

    public static enum Variant {
        DEFAULT,
        FOREST,
        PLAINS,
        MOUNTAIN,
        FUNGAL,
        SWAMP,
        DESERT,
        TAIGA,
        MESA,
        MOSSY;

    }
}

