/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import vazkii.botania.common.block.ModBlocks;

public class BlockGhostRail
extends AbstractRailBlock {
    private static final String TAG_FLOAT_TICKS = "botania:float_ticks";
    private final Map<RegistryKey<World>, Set<AbstractMinecartEntity>> floatingCarts = new HashMap<RegistryKey<World>, Set<AbstractMinecartEntity>>();

    public BlockGhostRail(AbstractBlock.Properties builder) {
        super(true, builder);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208166_S, (Comparable)RailShape.NORTH_SOUTH));
        MinecraftForge.EVENT_BUS.addListener(this::cartSpawn);
        MinecraftForge.EVENT_BUS.addListener(this::worldTick);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208166_S});
    }

    private void updateFloating(AbstractMinecartEntity cart) {
        cart.field_70170_p.func_217381_Z().func_76320_a("cartFloating");
        int floatTicks = cart.getPersistentData().func_74762_e(TAG_FLOAT_TICKS);
        Preconditions.checkState((floatTicks > 0 ? 1 : 0) != 0);
        BlockPos entPos = cart.func_233580_cy_();
        BlockState state = cart.field_70170_p.func_180495_p(entPos);
        boolean air = state.isAir((IBlockReader)cart.field_70170_p, entPos);
        if (state.func_177230_c() == ModBlocks.dreamwood || state.func_177230_c() != ModBlocks.ghostRail && state.func_235714_a_((ITag)BlockTags.field_203437_y)) {
            cart.field_70170_p.func_217379_c(2003, entPos, 0);
            cart.getPersistentData().func_74768_a(TAG_FLOAT_TICKS, 0);
        } else {
            BlockPos down = entPos.func_177977_b();
            BlockState stateBelow = cart.field_70170_p.func_180495_p(down);
            boolean airBelow = stateBelow.isAir((IBlockReader)cart.field_70170_p, down);
            if (air && airBelow || !air && !airBelow) {
                cart.field_70145_X = true;
            }
            cart.func_213293_j(cart.func_213322_ci().func_82615_a() * 1.4, 0.2, cart.func_213322_ci().func_82616_c() * 1.4);
            cart.getPersistentData().func_74768_a(TAG_FLOAT_TICKS, floatTicks - 1);
            cart.field_70170_p.func_217379_c(2000, entPos, 0);
        }
        cart.field_70170_p.func_217381_Z().func_76319_b();
    }

    public void onMinecartPass(BlockState state, World world, BlockPos pos, AbstractMinecartEntity cart) {
        super.onMinecartPass(state, world, pos, cart);
        if (!world.field_72995_K) {
            cart.getPersistentData().func_74768_a(TAG_FLOAT_TICKS, 20);
            this.addFloatingCart(cart);
            this.updateFloating(cart);
        }
    }

    private void addFloatingCart(AbstractMinecartEntity cart) {
        if (cart.func_70089_S() && cart.getPersistentData().func_74762_e(TAG_FLOAT_TICKS) > 0) {
            this.floatingCarts.computeIfAbsent((RegistryKey<World>)cart.field_70170_p.func_234923_W_(), t -> Collections.newSetFromMap(new WeakHashMap())).add(cart);
        }
    }

    private void cartSpawn(EntityJoinWorldEvent evt) {
        if (!evt.getWorld().field_72995_K && evt.getEntity() instanceof AbstractMinecartEntity) {
            this.addFloatingCart((AbstractMinecartEntity)evt.getEntity());
        }
    }

    private void worldTick(TickEvent.WorldTickEvent evt) {
        if (!evt.world.func_201670_d() && evt.phase == TickEvent.Phase.END) {
            evt.world.func_217381_Z().func_76320_a("cartFloatingIter");
            Iterator iter = this.floatingCarts.getOrDefault(evt.world.func_234923_W_(), Collections.emptySet()).iterator();
            while (iter.hasNext()) {
                AbstractMinecartEntity c = (AbstractMinecartEntity)iter.next();
                BlockPos entPos = c.func_233580_cy_();
                if (!(c.func_70089_S() && c.isAddedToWorld() && c.field_70170_p.func_175667_e(entPos) && c.getPersistentData().func_74762_e(TAG_FLOAT_TICKS) > 0)) {
                    c.field_70145_X = false;
                    iter.remove();
                    continue;
                }
                this.updateFloating(c);
                if (c.getPersistentData().func_74762_e(TAG_FLOAT_TICKS) > 0) continue;
                c.field_70145_X = false;
                iter.remove();
            }
            evt.world.func_217381_Z().func_76319_b();
        }
    }

    @Nonnull
    public Property<RailShape> func_176560_l() {
        return BlockStateProperties.field_208166_S;
    }
}

