/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.TileBrewery;
import vazkii.botania.common.block.tile.TileSimpleInventory;

public class BlockBrewery
extends BlockModWaterloggable
implements ITileEntityProvider,
IWandHUD {
    private static final VoxelShape SHAPE = BlockBrewery.func_208617_a((double)6.0, (double)0.8, (double)6.0, (double)10.0, (double)15.2, (double)10.0);

    public BlockBrewery(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208194_u});
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileBrewery brew = (TileBrewery)world.func_175625_s(pos);
        if (player.func_225608_bj_()) {
            if (brew.recipe == null && !((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u)).booleanValue()) {
                vazkii.botania.common.core.helper.InventoryHelper.withdrawFromInventory(brew, player);
                return ActionResultType.SUCCESS;
            }
        } else {
            ItemStack stack = player.func_184586_b(hand);
            if (!stack.func_190926_b()) {
                return brew.addItem(player, stack, hand) ? ActionResultType.SUCCESS : ActionResultType.PASS;
            }
        }
        return ActionResultType.PASS;
    }

    public void func_196243_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileSimpleInventory inv = (TileSimpleInventory)world.func_175625_s(pos);
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)inv.getItemHandler());
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileBrewery brew = (TileBrewery)world.func_175625_s(pos);
        return brew.signal;
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Nonnull
    public TileEntity func_196283_a_(@Nonnull IBlockReader world) {
        return new TileBrewery();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(MatrixStack ms, Minecraft mc, World world, BlockPos pos) {
        ((TileBrewery)world.func_175625_s(pos)).renderHUD(ms, mc);
    }
}

