/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.botania.api.corporea.InvWithLocation;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.block.subtile.functional.SubTileSpectranthemum;
import vazkii.botania.common.core.helper.InventoryHelper;
import vazkii.botania.mixin.AccessorItemEntity;

public class SubTileHopperhock
extends TileEntityFunctionalFlower {
    private static final String TAG_FILTER_TYPE = "filterType";
    private static final int RANGE_MANA = 10;
    private static final int RANGE = 6;
    private static final int RANGE_MANA_MINI = 2;
    private static final int RANGE_MINI = 1;
    private int filterType = 0;

    public SubTileHopperhock(TileEntityType<?> type) {
        super(type);
    }

    public SubTileHopperhock() {
        this(ModSubtiles.HOPPERHOCK);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.func_145831_w().field_72995_K || this.redstoneSignal > 0) {
            return;
        }
        boolean pulledAny = false;
        int range = this.getRange();
        BlockPos pos = this.getEffectivePos();
        List items = this.func_145831_w().func_217357_a(ItemEntity.class, new AxisAlignedBB(pos.func_177982_a(-range, -range, -range), pos.func_177982_a(range + 1, range + 1, range + 1)));
        int slowdown = this.getSlowdownFactor();
        for (ItemEntity item : items) {
            int age = ((AccessorItemEntity)item).getAge();
            if (age < 60 + slowdown || age >= 105 && age < 110 || !item.func_70089_S() || item.func_92059_d().func_190926_b()) continue;
            ItemStack stack = item.func_92059_d();
            IItemHandler invToPutItemIn = null;
            boolean priorityInv = false;
            int amountToPutIn = 0;
            for (Direction dir : Direction.values()) {
                boolean priority;
                BlockPos pos_ = pos.func_177972_a(dir);
                InvWithLocation inv = InventoryHelper.getInventoryWithLocation(this.func_145831_w(), pos_, dir.func_176734_d());
                if (inv == null) continue;
                List<ItemStack> filter = this.getFilterForInventory(pos_, true);
                boolean canAccept = this.canAcceptItem(stack, filter, this.filterType);
                ItemStack simulate = ItemHandlerHelper.insertItem((IItemHandler)inv.getHandler(), (ItemStack)stack, (boolean)true);
                int availablePut = stack.func_190916_E() - simulate.func_190916_E();
                if (!(canAccept &= availablePut > 0)) continue;
                boolean bl = priority = !filter.isEmpty();
                if (priorityInv && !priority) continue;
                invToPutItemIn = inv.getHandler();
                priorityInv = priority;
                amountToPutIn = availablePut;
            }
            if (invToPutItemIn == null || !item.func_70089_S()) continue;
            SubTileSpectranthemum.spawnExplosionParticles((Entity)item, 3);
            ItemHandlerHelper.insertItem(invToPutItemIn, (ItemStack)stack.func_77979_a(amountToPutIn), (boolean)false);
            item.func_92058_a(stack);
            pulledAny = true;
        }
        if (pulledAny && this.getMana() > 0) {
            this.addMana(-1);
        }
    }

    public boolean canAcceptItem(ItemStack stack, List<ItemStack> filter, int filterType) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (filter.isEmpty()) {
            return true;
        }
        switch (filterType) {
            case 0: {
                boolean anyFilter = false;
                for (ItemStack filterEntry : filter) {
                    if (filterEntry == null) continue;
                    anyFilter = true;
                    boolean itemEqual = stack.func_77973_b() == filterEntry.func_77973_b();
                    boolean nbtEqual = ItemStack.func_77970_a((ItemStack)filterEntry, (ItemStack)stack);
                    if (itemEqual && nbtEqual) {
                        return true;
                    }
                    if (!(stack.func_77973_b() instanceof IManaItem) || !itemEqual) continue;
                    return true;
                }
                return !anyFilter;
            }
            case 1: {
                return !this.canAcceptItem(stack, filter, 0);
            }
        }
        return true;
    }

    public List<ItemStack> getFilterForInventory(BlockPos pos, boolean recursiveForDoubleChests) {
        ChestType type;
        BlockState chest;
        ArrayList<ItemStack> filter = new ArrayList<ItemStack>();
        if (recursiveForDoubleChests && (chest = this.func_145831_w().func_180495_p(pos)).func_235901_b_((Property)ChestBlock.field_196314_b) && (type = (ChestType)chest.func_177229_b((Property)ChestBlock.field_196314_b)) != ChestType.SINGLE) {
            BlockPos other = pos.func_177972_a(ChestBlock.func_196311_i((BlockState)chest));
            if (this.func_145831_w().func_180495_p(other).func_177230_c() == chest.func_177230_c()) {
                filter.addAll(this.getFilterForInventory(other, false));
            }
        }
        for (Direction dir : Direction.values()) {
            AxisAlignedBB aabb = new AxisAlignedBB(pos.func_177972_a(dir));
            List frames = this.func_145831_w().func_217357_a(ItemFrameEntity.class, aabb);
            for (ItemFrameEntity frame : frames) {
                if (frame.func_174811_aO() != dir) continue;
                filter.add(frame.func_82335_i());
            }
        }
        return filter;
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public boolean onWanded(PlayerEntity player, ItemStack wand) {
        if (player == null || player.func_225608_bj_()) {
            this.filterType = this.filterType == 2 ? 0 : this.filterType + 1;
            this.sync();
            return true;
        }
        return super.onWanded(player, wand);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), this.getRange());
    }

    public int getRange() {
        return this.getMana() > 0 ? 10 : 6;
    }

    @Override
    public void writeToPacketNBT(CompoundNBT cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_FILTER_TYPE, this.filterType);
    }

    @Override
    public void readFromPacketNBT(CompoundNBT cmp) {
        super.readFromPacketNBT(cmp);
        this.filterType = cmp.func_74762_e(TAG_FILTER_TYPE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(MatrixStack ms, Minecraft mc) {
        super.renderHUD(ms, mc);
        String filter = I18n.func_135052_a((String)("botaniamisc.filter" + this.filterType), (Object[])new Object[0]);
        int x = mc.func_228018_at_().func_198107_o() / 2 - mc.field_71466_p.func_78256_a(filter) / 2;
        int y = mc.func_228018_at_().func_198087_p() / 2 + 30;
        mc.field_71466_p.func_238405_a_(ms, filter, (float)x, (float)y, TextFormatting.GRAY.func_211163_e().intValue());
        RenderSystem.disableLighting();
    }

    @Override
    public int getMaxMana() {
        return 20;
    }

    @Override
    public int getColor() {
        return 0x3F3F3F;
    }

    public static class Mini
    extends SubTileHopperhock {
        public Mini() {
            super(ModSubtiles.HOPPERHOCK_CHIBI);
        }

        @Override
        public int getRange() {
            return this.getMana() > 0 ? 2 : 1;
        }
    }
}

