/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.item.IFlowerPlaceable;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.mixin.AccessorItemEntity;

public class SubTileRannuncarpus
extends TileEntityFunctionalFlower {
    private static final int RANGE = 2;
    private static final int RANGE_Y = 3;
    private static final int RANGE_PLACE_MANA = 8;
    private static final int RANGE_PLACE = 6;
    private static final int RANGE_PLACE_Y = 6;
    private static final int RANGE_PLACE_MANA_MINI = 3;
    private static final int RANGE_PLACE_MINI = 2;
    private static final int RANGE_PLACE_Y_MINI = 2;

    public SubTileRannuncarpus(TileEntityType<?> type) {
        super(type);
    }

    public SubTileRannuncarpus() {
        this(ModSubtiles.RANNUNCARPUS);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.func_145831_w().field_72995_K || this.redstoneSignal > 0) {
            return;
        }
        if (this.ticksExisted % 10 == 0) {
            List items = this.func_145831_w().func_217357_a(ItemEntity.class, new AxisAlignedBB(this.getEffectivePos().func_177982_a(-2, -3, -2), this.getEffectivePos().func_177982_a(3, 4, 3)));
            List<BlockPos> validPositions = this.getCandidatePositions();
            int slowdown = this.getSlowdownFactor();
            for (ItemEntity item : items) {
                ItemStack stack;
                Item stackItem;
                int age = ((AccessorItemEntity)item).getAge();
                if (age < 60 + slowdown || !item.func_70089_S() || item.func_92059_d().func_190926_b() || !((stackItem = (stack = item.func_92059_d()).func_77973_b()) instanceof BlockItem) && !(stackItem instanceof IFlowerPlaceable) || validPositions.isEmpty()) continue;
                BlockPos coords = validPositions.get(this.func_145831_w().field_73012_v.nextInt(validPositions.size()));
                BlockRayTraceResult ray = new BlockRayTraceResult(Vector3d.field_186680_a, Direction.UP, coords, false);
                RannuncarpusPlaceContext ctx = new RannuncarpusPlaceContext(this.func_145831_w(), stack, ray);
                boolean success = false;
                if (stackItem instanceof IFlowerPlaceable) {
                    success = ((IFlowerPlaceable)stackItem).tryPlace(this, ctx);
                }
                if (stackItem instanceof BlockItem) {
                    success = ((BlockItem)stackItem).func_195942_a((BlockItemUseContext)ctx).func_226246_a_();
                }
                if (!success) continue;
                if (((Boolean)ConfigHandler.COMMON.blockBreakParticles.get()).booleanValue()) {
                    BlockState state = this.func_145831_w().func_180495_p(ctx.func_195995_a());
                    this.func_145831_w().func_217379_c(2001, coords, Block.func_196246_j((BlockState)state));
                }
                validPositions.remove(coords);
                if (this.getMana() > 1) {
                    this.addMana(-1);
                }
                return;
            }
        }
    }

    public BlockState getUnderlyingBlock() {
        return this.func_145831_w().func_180495_p(this.getEffectivePos().func_177979_c(this.isFloating() ? 1 : 2));
    }

    private List<BlockPos> getCandidatePositions() {
        int rangePlace = this.getRange();
        int rangePlaceY = this.getRangeY();
        BlockPos center = this.getEffectivePos();
        BlockState filter = this.getUnderlyingBlock();
        ArrayList<BlockPos> ret = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)center.func_177982_a(-rangePlace, -rangePlaceY, -rangePlace), (BlockPos)center.func_177982_a(rangePlace, rangePlaceY, rangePlace))) {
            BlockState state = this.func_145831_w().func_180495_p(pos);
            BlockState up = this.func_145831_w().func_180495_p(pos.func_177984_a());
            if (filter != state || !up.isAir((IBlockReader)this.func_145831_w(), pos.func_177984_a()) && !up.func_185904_a().func_76222_j()) continue;
            ret.add(pos.func_185334_h());
        }
        return ret;
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(MatrixStack ms, Minecraft mc) {
        super.renderHUD(ms, mc);
        BlockState filter = this.getUnderlyingBlock();
        ItemStack recieverStack = new ItemStack((IItemProvider)filter.func_177230_c());
        int color = this.getColor();
        if (!recieverStack.func_190926_b()) {
            ITextComponent stackName = recieverStack.func_200301_q();
            int width = 16 + mc.field_71466_p.func_238414_a_((ITextProperties)stackName) / 2;
            int x = mc.func_228018_at_().func_198107_o() / 2 - width;
            int y = mc.func_228018_at_().func_198087_p() / 2 + 30;
            mc.field_71466_p.func_238407_a_(ms, (ITextProperties)stackName, (float)(x + 20), (float)(y + 5), color);
            mc.func_175599_af().func_180450_b(recieverStack, x, y);
        }
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), this.getRange());
    }

    public int getRange() {
        return this.getMana() > 0 ? 8 : 6;
    }

    public int getRangeY() {
        return 6;
    }

    @Override
    public int getMaxMana() {
        return 20;
    }

    @Override
    public int getColor() {
        return 16757375;
    }

    private static class RannuncarpusPlaceContext
    extends BlockItemUseContext {
        private final Direction[] lookDirs;

        public RannuncarpusPlaceContext(World world, ItemStack stack, BlockRayTraceResult rtr) {
            super(world, null, Hand.MAIN_HAND, stack, rtr);
            List<Direction> tmp = Arrays.asList(Direction.values());
            Collections.shuffle(tmp);
            this.lookDirs = tmp.toArray(new Direction[6]);
        }

        @Nonnull
        public Direction func_196010_d() {
            return this.func_196009_e()[0];
        }

        @Nonnull
        public Direction[] func_196009_e() {
            return this.lookDirs;
        }
    }

    public static class Mini
    extends SubTileRannuncarpus {
        public Mini() {
            super(ModSubtiles.RANNUNCARPUS_CHIBI);
        }

        @Override
        public int getRange() {
            return this.getMana() > 0 ? 3 : 2;
        }

        @Override
        public int getRangeY() {
            return 2;
        }
    }
}

