/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DetectorRailBlock;
import net.minecraft.block.HoneyBlock;
import net.minecraft.block.SlimeBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.PistonTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.ModSubtiles;

public class SubTileEntropinnyum
extends TileEntityGeneratingFlower {
    private static final String TAG_UNETHICAL = "botania:unethical";
    private static final int RANGE = 12;
    private static final int EXPLODE_EFFECT_EVENT = 0;
    private static final int ANGRY_EFFECT_EVENT = 1;

    public SubTileEntropinnyum() {
        super(ModSubtiles.ENTROPINNYUM);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityJoin);
    }

    private void onEntityJoin(EntityJoinWorldEvent evt) {
        if (!evt.getWorld().field_72995_K && evt.getEntity() instanceof TNTEntity && SubTileEntropinnyum.isUnethical(evt.getEntity())) {
            evt.getEntity().getPersistentData().func_74757_a(TAG_UNETHICAL, true);
        }
    }

    private static boolean isUnethical(Entity e) {
        BlockPos center = e.func_233580_cy_();
        int x = center.func_177958_n();
        int y = center.func_177956_o();
        int z = center.func_177952_p();
        int range = 3;
        int movingPistons = 0;
        int rails = 0;
        int slimes = 0;
        for (BlockPos pos : BlockPos.func_191531_b((int)(x - range), (int)(y - range), (int)(z - range), (int)(x + range + 1), (int)(y + range + 1), (int)(z + range + 1))) {
            BlockState state = e.field_70170_p.func_180495_p(pos);
            if (state.func_177230_c() == Blocks.field_196603_bb) {
                ++movingPistons;
                TileEntity te = e.field_70170_p.func_175625_s(pos);
                if (te instanceof PistonTileEntity) {
                    state = ((PistonTileEntity)te).func_200230_i();
                }
            }
            if (state.func_177230_c() instanceof DetectorRailBlock) {
                ++rails;
            } else if (state.func_177230_c() instanceof SlimeBlock || state.func_177230_c() instanceof HoneyBlock) {
                ++slimes;
            }
            if (movingPistons <= 0 || rails <= 0 || slimes <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!this.func_145831_w().field_72995_K && this.getMana() == 0) {
            List tnts = this.func_145831_w().func_217357_a(TNTEntity.class, new AxisAlignedBB(this.getEffectivePos().func_177982_a(-12, -12, -12), this.getEffectivePos().func_177982_a(13, 13, 13)));
            for (TNTEntity tnt : tnts) {
                FluidState fluid = this.func_145831_w().func_204610_c(tnt.func_233580_cy_());
                if (tnt.func_184536_l() != 1 || !tnt.func_70089_S() || !fluid.func_206888_e()) continue;
                boolean unethical = tnt.getPersistentData().func_74767_n(TAG_UNETHICAL);
                tnt.func_184185_a(unethical ? SoundEvents.field_187541_bC : SoundEvents.field_187539_bB, 0.2f, (1.0f + (this.func_145831_w().field_73012_v.nextFloat() - this.func_145831_w().field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                tnt.func_70106_y();
                this.addMana(unethical ? 3 : this.getMaxMana());
                this.sync();
                this.func_145831_w().func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), unethical ? 1 : 0, tnt.func_145782_y());
                break;
            }
        }
    }

    public boolean func_145842_c(int event, int param) {
        if (event == 0) {
            if (this.func_145831_w().field_72995_K && this.func_145831_w().func_73045_a(param) instanceof TNTEntity) {
                Entity e = this.func_145831_w().func_73045_a(param);
                for (int i = 0; i < 50; ++i) {
                    SparkleParticleData data = SparkleParticleData.sparkle((float)(Math.random() * (double)0.65f + 1.25), 1.0f, (float)Math.random() * 0.25f, (float)Math.random() * 0.25f, 12);
                    this.field_145850_b.func_195594_a((IParticleData)data, e.func_226277_ct_() + Math.random() * 4.0 - 2.0, e.func_226278_cu_() + Math.random() * 4.0 - 2.0, e.func_226281_cx_() + Math.random() * 4.0 - 2.0, 0.0, 0.0, 0.0);
                }
                this.func_145831_w().func_195594_a((IParticleData)ParticleTypes.field_197626_s, e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), 1.0, 0.0, 0.0);
            }
            return true;
        }
        if (event == 1) {
            if (this.func_145831_w().field_72995_K && this.func_145831_w().func_73045_a(param) instanceof TNTEntity) {
                Entity e = this.func_145831_w().func_73045_a(param);
                for (int i = 0; i < 50; ++i) {
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197609_b, e.func_226277_ct_() + Math.random() * 4.0 - 2.0, e.func_226278_cu_() + Math.random() * 4.0 - 2.0, e.func_226281_cx_() + Math.random() * 4.0 - 2.0, 0.0, 0.0, 0.0);
                }
            }
            return true;
        }
        return super.func_145842_c(event, param);
    }

    @Override
    public int getColor() {
        return 0xCB0000;
    }

    @Override
    public int getMaxMana() {
        return 6500;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), 12);
    }
}

