/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.CratePattern;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileOpenCrate;
import vazkii.botania.common.item.ModItems;

public class TileCraftCrate
extends TileOpenCrate {
    private static final String TAG_CRAFTING_RESULT = "craft_result";
    private int signal = 0;
    private ItemStack craftResult = ItemStack.field_190927_a;

    public TileCraftCrate() {
        super(ModTiles.CRAFT_CRATE);
    }

    @Override
    protected Inventory createItemHandler() {
        return new Inventory(9){

            public int func_70297_j_() {
                return 1;
            }

            public boolean func_94041_b(int slot, ItemStack stack) {
                return !TileCraftCrate.this.isLocked(slot);
            }
        };
    }

    public CratePattern getPattern() {
        BlockState state = this.func_195044_w();
        if (state.func_177230_c() != ModBlocks.craftCrate) {
            return CratePattern.NONE;
        }
        return (CratePattern)((Object)state.func_177229_b(BotaniaStateProps.CRATE_PATTERN));
    }

    private boolean isLocked(int slot) {
        return this.getPattern().openSlots.get(slot) == false;
    }

    @Override
    public void readPacketNBT(CompoundNBT tag) {
        super.readPacketNBT(tag);
        this.craftResult = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(TAG_CRAFTING_RESULT));
    }

    @Override
    public void writePacketNBT(CompoundNBT tag) {
        super.writePacketNBT(tag);
        tag.func_218657_a(TAG_CRAFTING_RESULT, (INBT)this.craftResult.func_77955_b(new CompoundNBT()));
    }

    @Override
    public void func_73660_a() {
        int newSignal;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.canEject() && this.isFull() && this.craft(true)) {
            this.ejectAll();
        }
        for (newSignal = 0; newSignal < 9 && (this.isLocked(newSignal) || !this.getItemHandler().func_70301_a(newSignal).func_190926_b()); ++newSignal) {
        }
        if (newSignal != this.signal) {
            this.signal = newSignal;
            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
        }
    }

    private boolean craft(boolean fullCheck) {
        if (fullCheck && !this.isFull()) {
            return false;
        }
        CraftingInventory craft = new CraftingInventory(new Container(ContainerType.field_221518_l, -1){

            public boolean func_75145_c(@Nonnull PlayerEntity player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < craft.func_70302_i_(); ++i) {
            ItemStack stack = this.getItemHandler().func_70301_a(i);
            if (stack.func_190926_b() || this.isLocked(i) || stack.func_77973_b() == ModItems.placeholder) continue;
            craft.func_70299_a(i, stack);
        }
        Optional matchingRecipe = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)craft, this.field_145850_b);
        matchingRecipe.ifPresent(recipe -> {
            this.craftResult = recipe.func_77572_b((IInventory)craft);
            NonNullList remainders = recipe.func_179532_b((IInventory)craft);
            for (int i = 0; i < craft.func_70302_i_(); ++i) {
                ItemStack s = (ItemStack)remainders.get(i);
                if (!this.getItemHandler().func_70301_a(i).func_190926_b() && this.getItemHandler().func_70301_a(i).func_77973_b() == ModItems.placeholder) continue;
                this.getItemHandler().func_70299_a(i, s);
            }
        });
        return matchingRecipe.isPresent();
    }

    boolean isFull() {
        for (int i = 0; i < this.getItemHandler().func_70302_i_(); ++i) {
            if (this.isLocked(i) || !this.getItemHandler().func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private void ejectAll() {
        for (int i = 0; i < this.inventorySize(); ++i) {
            ItemStack stack = this.getItemHandler().func_70301_a(i);
            if (!stack.func_190926_b()) {
                this.eject(stack, false);
            }
            this.getItemHandler().func_70299_a(i, ItemStack.field_190927_a);
        }
        if (!this.craftResult.func_190926_b()) {
            this.eject(this.craftResult, false);
            this.craftResult = ItemStack.field_190927_a;
        }
    }

    @Override
    public boolean onWanded(World world, PlayerEntity player, ItemStack stack) {
        if (!world.field_72995_K && this.canEject()) {
            this.craft(false);
            this.ejectAll();
        }
        return true;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    @Override
    public int getSignal() {
        return this.signal;
    }
}

