/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import vazkii.botania.api.item.IExoflameHeatable;
import vazkii.botania.common.Botania;
import vazkii.botania.common.capability.SimpleCapProvider;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.AccessorAbstractFurnaceTileEntity;

public class ExoflameFurnaceHandler {
    @CapabilityInject(value=IExoflameHeatable.class)
    public static Capability<IExoflameHeatable> CAPABILITY;
    public static final ResourceLocation ID;

    public static void attachFurnaceCapability(AttachCapabilitiesEvent<TileEntity> event) {
        TileEntity te = (TileEntity)event.getObject();
        if (te instanceof AbstractFurnaceTileEntity) {
            AbstractFurnaceTileEntity furnace = (AbstractFurnaceTileEntity)te;
            SimpleCapProvider.attach(event, ID, CAPABILITY, new FurnaceExoflameHeatable(furnace));
        }
    }

    public static boolean canSmelt(AbstractFurnaceTileEntity furnace, IRecipe<?> recipe) {
        return ((AccessorAbstractFurnaceTileEntity)furnace).invokeCanSmelt(recipe);
    }

    public static IRecipeType<? extends AbstractCookingRecipe> getRecipeType(AbstractFurnaceTileEntity furnace) {
        return ((AccessorAbstractFurnaceTileEntity)furnace).getRecipeType();
    }

    static {
        ID = ResourceLocationHelper.prefix("exoflame_heatable");
    }

    private static class FurnaceExoflameHeatable
    implements IExoflameHeatable {
        private final AbstractFurnaceTileEntity furnace;
        private IRecipeType<? extends AbstractCookingRecipe> recipeType;
        private AbstractCookingRecipe currentRecipe;

        FurnaceExoflameHeatable(AbstractFurnaceTileEntity furnace) {
            this.furnace = furnace;
        }

        @Override
        public boolean canSmelt() {
            if (this.furnace.func_70301_a(0).func_190926_b()) {
                return false;
            }
            try {
                if (this.recipeType == null) {
                    this.recipeType = ExoflameFurnaceHandler.getRecipeType(this.furnace);
                }
                if (this.currentRecipe != null && this.currentRecipe.func_77569_a((IInventory)this.furnace, this.furnace.func_145831_w()) && ExoflameFurnaceHandler.canSmelt(this.furnace, this.currentRecipe)) {
                    return true;
                }
                this.currentRecipe = this.furnace.func_145831_w().func_199532_z().func_215371_a(this.recipeType, (IInventory)this.furnace, this.furnace.func_145831_w()).orElse(null);
                return ExoflameFurnaceHandler.canSmelt(this.furnace, this.currentRecipe);
            }
            catch (Throwable t) {
                Botania.LOGGER.error("Failed to determine if furnace TE can smelt", t);
                return false;
            }
        }

        @Override
        public int getBurnTime() {
            return ((AccessorAbstractFurnaceTileEntity)this.furnace).getBurnTime();
        }

        @Override
        public void boostBurnTime() {
            if (this.getBurnTime() == 0) {
                World world = this.furnace.func_145831_w();
                BlockPos pos = this.furnace.func_174877_v();
                world.func_175656_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)));
            }
            int burnTime = ((AccessorAbstractFurnaceTileEntity)this.furnace).getBurnTime();
            ((AccessorAbstractFurnaceTileEntity)this.furnace).setBurnTime(burnTime + 200);
        }

        @Override
        public void boostCookTime() {
            int cookTime = ((AccessorAbstractFurnaceTileEntity)this.furnace).getCookTime();
            ((AccessorAbstractFurnaceTileEntity)this.furnace).setCookTime(Math.min(this.currentRecipe.func_222137_e() - 1, cookTime + 1));
        }
    }
}

