/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Util;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.registries.IForgeRegistry;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.entity.EntityPixie;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.armor.elementium.ItemElementiumHelm;
import vazkii.botania.common.lib.ResourceLocationHelper;

public final class PixieHandler {
    public static final Attribute PIXIE_SPAWN_CHANCE = new RangedAttribute("attribute.name.botania.pixieSpawnChance", 0.0, 0.0, 1.0);
    private static final Map<EquipmentSlotType, UUID> DEFAULT_MODIFIER_UUIDS = (Map)Util.func_200696_a(new EnumMap(EquipmentSlotType.class), m -> {
        m.put(EquipmentSlotType.HEAD, UUID.fromString("3c1f559c-9ec4-412d-ada0-dbf3e714088e"));
        m.put(EquipmentSlotType.CHEST, UUID.fromString("9631121c-16f0-4ed4-ba0a-0e7a063cb71c"));
        m.put(EquipmentSlotType.LEGS, UUID.fromString("a87117a1-ac15-4b17-9fd5-e98d5fe31ff1"));
        m.put(EquipmentSlotType.FEET, UUID.fromString("ff67d38a-c5be-4a00-90ed-76bb12c45523"));
        m.put(EquipmentSlotType.MAINHAND, UUID.fromString("995829fa-94c0-41bd-b046-0468c509a488"));
        m.put(EquipmentSlotType.OFFHAND, UUID.fromString("34f62de8-f652-4fe7-899f-a8fc938c4940"));
    });
    private static final Effect[] potions = new Effect[]{Effects.field_76440_q, Effects.field_82731_v, Effects.field_76421_d, Effects.field_76437_t};

    private PixieHandler() {
    }

    public static void registerAttribute(RegistryEvent.Register<Attribute> evt) {
        IForgeRegistry r = evt.getRegistry();
        ModBlocks.register(r, ResourceLocationHelper.prefix("pixie_spawn_chance"), PIXIE_SPAWN_CHANCE);
    }

    public static AttributeModifier makeModifier(EquipmentSlotType slot, String name, double amount) {
        return new AttributeModifier(DEFAULT_MODIFIER_UUIDS.get(slot), name, amount, AttributeModifier.Operation.ADDITION);
    }

    public static void onDamageTaken(LivingHurtEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof PlayerEntity && event.getSource().func_76346_g() instanceof LivingEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            double chance = player.func_233637_b_(PIXIE_SPAWN_CHANCE);
            ItemStack sword = PlayerHelper.getFirstHeldItem((LivingEntity)player, s -> s.func_77973_b() == ModItems.elementiumSword);
            if (Math.random() < chance) {
                EntityPixie pixie = new EntityPixie(player.field_70170_p);
                pixie.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_() + 2.0, player.func_226281_cx_());
                if (((ItemElementiumHelm)ModItems.elementiumHelm).hasArmorSet(player)) {
                    pixie.setApplyPotionEffect(new EffectInstance(potions[event.getEntityLiving().field_70170_p.field_73012_v.nextInt(potions.length)], 40, 0));
                }
                float dmg = 4.0f;
                if (!sword.func_190926_b()) {
                    dmg += 2.0f;
                }
                pixie.setProps((LivingEntity)event.getSource().func_76346_g(), (LivingEntity)player, 0, dmg);
                pixie.func_213386_a((IWorld)player.field_70170_p, player.field_70170_p.func_175649_E(pixie.func_233580_cy_()), SpawnReason.EVENT, null, null);
                player.field_70170_p.func_217376_c((Entity)pixie);
            }
        }
    }
}

