/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.helper;

import com.mojang.datafixers.util.Pair;
import java.util.function.Predicate;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;

public final class PlayerHelper {
    public static boolean hasAnyHeldItem(PlayerEntity player) {
        return !player.func_184614_ca().func_190926_b() || !player.func_184592_cb().func_190926_b();
    }

    public static boolean hasHeldItem(PlayerEntity player, Item item) {
        return !player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() == item || !player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() == item;
    }

    public static boolean hasHeldItemClass(PlayerEntity player, Item template) {
        return PlayerHelper.hasHeldItemClass(player, template.getClass());
    }

    public static boolean hasHeldItemClass(PlayerEntity player, Class<?> template) {
        return !player.func_184614_ca().func_190926_b() && template.isAssignableFrom(player.func_184614_ca().func_77973_b().getClass()) || !player.func_184592_cb().func_190926_b() && template.isAssignableFrom(player.func_184592_cb().func_77973_b().getClass());
    }

    public static ItemStack getFirstHeldItem(LivingEntity living, Item item) {
        return PlayerHelper.getFirstHeldItem(living, (ItemStack s) -> s.func_77973_b() == item);
    }

    public static ItemStack getFirstHeldItem(LivingEntity living, Predicate<ItemStack> pred) {
        ItemStack main = living.func_184614_ca();
        ItemStack offhand = living.func_184592_cb();
        if (!main.func_190926_b() && pred.test(main)) {
            return main;
        }
        if (!offhand.func_190926_b() && pred.test(offhand)) {
            return offhand;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getFirstHeldItemClass(PlayerEntity player, Class<?> template) {
        return PlayerHelper.getFirstHeldItem((LivingEntity)player, (ItemStack s) -> template.isAssignableFrom(s.func_77973_b().getClass()));
    }

    public static ItemStack getAmmo(PlayerEntity player, Predicate<ItemStack> ammoFunc) {
        if (ammoFunc.test(player.func_184586_b(Hand.OFF_HAND))) {
            return player.func_184586_b(Hand.OFF_HAND);
        }
        if (ammoFunc.test(player.func_184586_b(Hand.MAIN_HAND))) {
            return player.func_184586_b(Hand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!ammoFunc.test(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean hasAmmo(PlayerEntity player, Predicate<ItemStack> ammoFunc) {
        return !PlayerHelper.getAmmo(player, ammoFunc).func_190926_b();
    }

    public static void consumeAmmo(PlayerEntity player, Predicate<ItemStack> ammoFunc) {
        ItemStack ammo = PlayerHelper.getAmmo(player, ammoFunc);
        if (!ammo.func_190926_b()) {
            ammo.func_190918_g(1);
        }
    }

    public static boolean hasItem(PlayerEntity player, Predicate<ItemStack> itemFunc) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (!itemFunc.test(player.field_71071_by.func_70301_a(i))) continue;
            return true;
        }
        return false;
    }

    public static void grantCriterion(ServerPlayerEntity player, ResourceLocation advancementId, String criterion) {
        PlayerAdvancements advancements = player.func_192039_O();
        AdvancementManager manager = player.func_71121_q().func_73046_m().func_191949_aK();
        Advancement advancement = manager.func_192778_a(advancementId);
        if (advancement != null) {
            advancements.func_192750_a(advancement, criterion);
        }
    }

    public static ActionResultType substituteUse(ItemUseContext ctx, ItemStack toUse) {
        return (ActionResultType)PlayerHelper.substituteUseTrackPos(ctx, toUse).getFirst();
    }

    public static Pair<ActionResultType, BlockPos> substituteUseTrackPos(ItemUseContext ctx, ItemStack toUse) {
        ItemUseContext newCtx;
        ItemStack save = ItemStack.field_190927_a;
        BlockRayTraceResult hit = new BlockRayTraceResult(ctx.func_221532_j(), ctx.func_196000_l(), ctx.func_195995_a(), ctx.func_221533_k());
        if (ctx.func_195999_j() != null) {
            save = ctx.func_195999_j().func_184586_b(ctx.func_221531_n());
            ctx.func_195999_j().func_184611_a(ctx.func_221531_n(), toUse);
            newCtx = new ItemUseContext(ctx.func_195999_j(), ctx.func_221531_n(), hit);
        } else {
            newCtx = new ItemUseContext(ctx.func_195991_k(), null, ctx.func_221531_n(), toUse, hit);
        }
        BlockPos finalPos = new BlockItemUseContext(newCtx).func_195995_a();
        ActionResultType result = toUse.func_196084_a(newCtx);
        if (ctx.func_195999_j() != null) {
            ctx.func_195999_j().func_184611_a(ctx.func_221531_n(), save);
        }
        return Pair.of((Object)result, (Object)finalPos);
    }

    private PlayerHelper() {
    }
}

