/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.crafting.StateIngredientBlock;
import vazkii.botania.common.crafting.StateIngredientBlockState;
import vazkii.botania.common.crafting.StateIngredientBlocks;
import vazkii.botania.common.crafting.StateIngredientTag;

public class StateIngredientHelper {
    public static StateIngredient of(Block block) {
        return new StateIngredientBlock(block);
    }

    public static StateIngredient of(BlockState state) {
        return new StateIngredientBlockState(state);
    }

    public static StateIngredient of(ITag.INamedTag<Block> tag) {
        return new StateIngredientTag(tag);
    }

    public static StateIngredient of(ResourceLocation id) {
        return new StateIngredientTag(id);
    }

    public static StateIngredient of(Set<Block> blocks) {
        return new StateIngredientBlocks(blocks);
    }

    public static StateIngredient deserialize(JsonObject object) {
        switch (JSONUtils.func_151200_h((JsonObject)object, (String)"type")) {
            case "tag": {
                return new StateIngredientTag((ITag.INamedTag<Block>)BlockTags.func_199894_a((String)JSONUtils.func_151200_h((JsonObject)object, (String)"tag")));
            }
            case "block": {
                return new StateIngredientBlock((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"block"))));
            }
            case "state": {
                return new StateIngredientBlockState(StateIngredientHelper.readBlockState(object));
            }
            case "blocks": {
                HashSet<Block> blocks = new HashSet<Block>();
                for (JsonElement element : JSONUtils.func_151214_t((JsonObject)object, (String)"blocks")) {
                    blocks.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(element.getAsString())));
                }
                return new StateIngredientBlocks(blocks);
            }
        }
        throw new JsonParseException("Unknown type!");
    }

    public static StateIngredient read(PacketBuffer buffer) {
        switch (buffer.func_150792_a()) {
            case 0: {
                int count = buffer.func_150792_a();
                HashSet<Block> set = new HashSet<Block>();
                for (int i = 0; i < count; ++i) {
                    Block block = (Block)buffer.readRegistryIdUnsafe(ForgeRegistries.BLOCKS);
                    set.add(block);
                }
                return new StateIngredientBlocks(set);
            }
            case 1: {
                return new StateIngredientBlock((Block)buffer.readRegistryIdUnsafe(ForgeRegistries.BLOCKS));
            }
            case 2: {
                return new StateIngredientBlockState(Block.func_196257_b((int)buffer.func_150792_a()));
            }
        }
        throw new IllegalArgumentException("Unknown input discriminator!");
    }

    public static JsonObject serializeBlockState(BlockState state) {
        CompoundNBT nbt = NBTUtil.func_190009_a((BlockState)state);
        ItemNBTHelper.renameTag(nbt, "Name", "name");
        ItemNBTHelper.renameTag(nbt, "Properties", "properties");
        Dynamic dyn = new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)nbt);
        return ((JsonElement)dyn.convert((DynamicOps)JsonOps.INSTANCE).getValue()).getAsJsonObject();
    }

    public static BlockState readBlockState(JsonObject object) {
        CompoundNBT nbt = (CompoundNBT)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)object).convert((DynamicOps)NBTDynamicOps.field_210820_a).getValue();
        ItemNBTHelper.renameTag(nbt, "name", "Name");
        ItemNBTHelper.renameTag(nbt, "properties", "Properties");
        String name = nbt.func_74779_i("Name");
        ResourceLocation id = ResourceLocation.func_208304_a((String)name);
        if (id == null || !ForgeRegistries.BLOCKS.containsKey(id)) {
            throw new IllegalArgumentException("Invalid or unknown block ID: " + name);
        }
        return NBTUtil.func_190008_d((CompoundNBT)nbt);
    }
}

