/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import javax.annotation.Nonnull;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.entity.ModEntities;

public class EntityPixie
extends FlyingEntity {
    private static final DataParameter<Integer> PIXIE_TYPE = EntityDataManager.func_187226_a(EntityPixie.class, (IDataSerializer)DataSerializers.field_187192_b);
    private LivingEntity summoner = null;
    private float damage = 0.0f;
    private EffectInstance effect = null;

    public EntityPixie(EntityType<EntityPixie> type, World world) {
        super(type, world);
    }

    public EntityPixie(World world) {
        this(ModEntities.PIXIE, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PIXIE_TYPE, (Object)0);
    }

    public void setPixieType(int type) {
        this.field_70180_af.func_187227_b(PIXIE_TYPE, (Object)type);
    }

    public int getPixieType() {
        return (Integer)this.field_70180_af.func_187225_a(PIXIE_TYPE);
    }

    public void setProps(LivingEntity target, LivingEntity summoner, int type, float damage) {
        this.func_70624_b(target);
        this.summoner = summoner;
        this.damage = damage;
        this.setPixieType(type);
    }

    public void setApplyPotionEffect(EffectInstance effect) {
        this.effect = effect;
    }

    protected void func_70619_bc() {
        LivingEntity target = this.func_70638_az();
        if (target != null) {
            double d0 = target.func_226277_ct_() + (double)(target.func_213311_cf() / 2.0f) - this.func_226277_ct_();
            double d1 = target.func_226278_cu_() + (double)(target.func_213302_cg() / 2.0f) - this.func_226278_cu_();
            double d2 = target.func_226281_cx_() + (double)(target.func_213311_cf() / 2.0f) - this.func_226281_cx_();
            double d3 = d0 * d0 + d1 * d1 + d2 * d2;
            float mod = 0.45f;
            if (this.getPixieType() == 1) {
                mod = 0.1f;
            }
            this.func_213293_j(d0 / d3 * (double)mod, d1 / d3 * (double)mod, d2 / d3 * (double)mod);
            if (Math.sqrt(d3) < 1.0) {
                if (this.summoner != null) {
                    if (this.summoner instanceof PlayerEntity) {
                        target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)this.summoner)), this.damage);
                    } else {
                        target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.summoner), this.damage);
                    }
                } else {
                    target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), this.damage);
                }
                if (this.effect != null && !(target instanceof PlayerEntity)) {
                    target.func_195064_c(this.effect);
                }
                this.func_70106_y();
            }
        }
        this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(this.func_213322_ci().func_82615_a(), this.func_213322_ci().func_82616_c())) * 180.0f / (float)Math.PI;
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (this.getPixieType() == 0 && source.func_76346_g() != this.summoner || this.getPixieType() == 1 && source.func_76346_g() instanceof PlayerEntity) {
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    public void func_70030_z() {
        boolean dark;
        super.func_70030_z();
        if (!(this.field_70170_p.field_72995_K || this.func_70638_az() != null && this.field_70173_aa <= 200)) {
            this.func_70106_y();
        }
        boolean bl = dark = this.getPixieType() == 1;
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 4; ++i) {
                float r = dark ? 0.1f : 1.0f;
                float g = dark ? 0.025f : 0.25f;
                float b = dark ? 0.09f : 0.9f;
                SparkleParticleData data = SparkleParticleData.sparkle(0.1f + (float)Math.random() * 0.25f, r, g, b, 12);
                this.field_70170_p.func_195594_a((IParticleData)data, this.func_226277_ct_() + (Math.random() - 0.5) * 0.25, this.func_226278_cu_() + 0.5 + (Math.random() - 0.5) * 0.25, this.func_226281_cx_() + (Math.random() - 0.5) * 0.25, 0.0, 0.0, 0.0);
            }
        }
    }

    public void func_70106_y() {
        if (this.field_70170_p != null && this.field_70170_p.field_72995_K && this.getPixieType() == 0) {
            for (int i = 0; i < 12; ++i) {
                SparkleParticleData data = SparkleParticleData.sparkle(1.0f + (float)Math.random() * 0.25f, 1.0f, 0.25f, 0.9f, 5);
                this.field_70170_p.func_195594_a((IParticleData)data, this.func_226277_ct_() + (Math.random() - 0.5) * 0.25, this.func_226278_cu_() + 0.5 + (Math.random() - 0.5) * 0.25, this.func_226281_cx_() + (Math.random() - 0.5) * 0.25, 0.0, 0.0, 0.0);
            }
        }
        super.func_70106_y();
    }

    public boolean func_213397_c(double dist) {
        return false;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }
}

