/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.corporea;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import vazkii.botania.api.corporea.ICorporeaRequest;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.api.corporea.IWrappedInventory;
import vazkii.botania.api.corporea.InvWithLocation;
import vazkii.botania.common.integration.corporea.WrappedInventoryBase;

public class WrappedIInventory
extends WrappedInventoryBase {
    protected final InvWithLocation inv;

    protected WrappedIInventory(InvWithLocation inv, ICorporeaSpark spark) {
        super(spark);
        this.inv = inv;
    }

    @Override
    public InvWithLocation getWrappedObject() {
        return this.inv;
    }

    @Override
    public List<ItemStack> countItems(ICorporeaRequest request) {
        return this.iterateOverSlots(request, false);
    }

    @Override
    public List<ItemStack> extractItems(ICorporeaRequest request) {
        return this.iterateOverSlots(request, true);
    }

    protected List<ItemStack> iterateOverSlots(ICorporeaRequest request, boolean doit) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = this.inv.getHandler().getSlots() - 1; i >= 0; --i) {
            ItemStack stackAt = this.inv.getHandler().getStackInSlot(i);
            if (!request.getMatcher().isStackValid(stackAt)) continue;
            int rem = Math.min(stackAt.func_190916_E(), request.getStillNeeded() == -1 ? stackAt.func_190916_E() : request.getStillNeeded());
            request.trackFound(stackAt.func_190916_E());
            if (rem > 0) {
                ItemStack copy = stackAt.func_77946_l();
                stacks.add(this.inv.getHandler().extractItem(i, rem, !doit));
                if (doit && this.spark != null) {
                    this.spark.onItemExtracted(copy);
                }
            }
            request.trackExtracted(rem);
            request.trackSatisfied(rem);
        }
        return stacks;
    }

    public static IWrappedInventory wrap(InvWithLocation inv, ICorporeaSpark spark) {
        return new WrappedIInventory(inv, spark);
    }
}

