/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.NoteBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileCacophonium;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.mixin.AccessorMobEntity;

public class ItemCacophonium
extends Item {
    private static final String TAG_SOUND = "sound";
    private static final String TAG_SOUND_NAME = "soundName";

    public ItemCacophonium(Item.Properties props) {
        super(props);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity entity, Hand hand) {
        if (entity instanceof MobEntity) {
            MobEntity living = (MobEntity)entity;
            SoundEvent sound = null;
            sound = living instanceof CreeperEntity ? SoundEvents.field_187572_ar : (living instanceof SlimeEntity ? (((SlimeEntity)living).func_189101_db() ? SoundEvents.field_187900_fz : SoundEvents.field_187886_fs) : ((AccessorMobEntity)living).callGetAmbientSound());
            if (sound != null) {
                if (!player.field_70170_p.field_72995_K) {
                    ItemNBTHelper.setString(stack, TAG_SOUND, Registry.field_212633_v.func_177774_c((Object)sound).toString());
                    ItemNBTHelper.setString(stack, TAG_SOUND_NAME, entity.func_200600_R().func_210760_d());
                    player.func_184611_a(hand, stack);
                }
                return ActionResultType.func_233537_a_((boolean)player.field_70170_p.field_72995_K);
            }
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        BlockPos pos;
        World world;
        Block block;
        ItemStack stack = ctx.func_195996_i();
        if (ItemCacophonium.getSound(stack) != null && (block = (world = ctx.func_195991_k()).func_180495_p(pos = ctx.func_195995_a()).func_177230_c()) instanceof NoteBlock) {
            world.func_175656_a(pos, ModBlocks.cacophonium.func_176223_P());
            ((TileCacophonium)world.func_175625_s((BlockPos)pos)).stack = stack.func_77946_l();
            stack.func_190918_g(1);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flags) {
        if (ItemCacophonium.isDOIT(stack)) {
            list.add((ITextComponent)new TranslationTextComponent("botaniamisc.justDoIt").func_240699_a_(TextFormatting.GRAY));
        } else if (ItemCacophonium.getSound(stack) != null) {
            list.add((ITextComponent)new TranslationTextComponent(ItemNBTHelper.getString(stack, TAG_SOUND_NAME, "")).func_240699_a_(TextFormatting.GRAY));
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (ItemCacophonium.getSound(stack) != null) {
            player.func_184598_c(hand);
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public void func_219972_a(World world, @Nonnull LivingEntity player, @Nonnull ItemStack stack, int count) {
        if (!world.field_72995_K && count % (ItemCacophonium.isDOIT(stack) ? 20 : 6) == 0) {
            ItemCacophonium.playSound(player.field_70170_p, stack, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundCategory.PLAYERS, 0.9f);
        }
    }

    public static void playSound(World world, ItemStack stack, double x, double y, double z, SoundCategory category, float volume) {
        if (stack.func_190926_b()) {
            return;
        }
        SoundEvent sound = ItemCacophonium.getSound(stack);
        if (sound != null) {
            world.func_184148_a(null, x, y, z, sound, category, volume, sound == ModSounds.doit ? 1.0f : (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Nullable
    private static SoundEvent getSound(ItemStack stack) {
        if (ItemCacophonium.isDOIT(stack)) {
            return ModSounds.doit;
        }
        try {
            return Registry.field_212633_v.func_218349_b(new ResourceLocation(ItemNBTHelper.getString(stack, TAG_SOUND, ""))).orElse(null);
        }
        catch (ResourceLocationException ex) {
            return null;
        }
    }

    private static boolean isDOIT(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_200301_q().getString().equalsIgnoreCase("shia labeouf");
    }
}

