/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.IManaTooltipDisplay;
import vazkii.botania.api.wand.ICoordBoundItem;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ItemManaMirror
extends Item
implements IManaItem,
ICoordBoundItem,
IManaTooltipDisplay {
    private static final String TAG_MANA = "mana";
    private static final String TAG_MANA_BACKLOG = "manaBacklog";
    private static final String TAG_POS = "pos";
    private static final DummyPool fallbackPool = new DummyPool();

    public ItemManaMirror(Item.Properties props) {
        super(props);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0f - this.getManaFractionForDisplay(stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (world.field_72995_K) {
            return;
        }
        IManaPool pool = this.getManaPool(stack);
        if (!(pool instanceof DummyPool)) {
            if (pool == null) {
                this.setMana(stack, 0);
            } else {
                pool.receiveMana(this.getManaBacklog(stack));
                this.setManaBacklog(stack, 0);
                this.setMana(stack, pool.getCurrentMana());
            }
        }
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        TileEntity tile;
        World world = ctx.func_195991_k();
        PlayerEntity player = ctx.func_195999_j();
        if (player != null && player.func_225608_bj_() && !world.field_72995_K && (tile = world.func_175625_s(ctx.func_195995_a())) instanceof IManaPool) {
            this.bindPool(ctx.func_195996_i(), tile);
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), ModSounds.ding, SoundCategory.PLAYERS, 1.0f, 1.0f);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public int getMana(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_MANA, 0);
    }

    public void setMana(ItemStack stack, int mana) {
        ItemNBTHelper.setInt(stack, TAG_MANA, Math.max(0, mana));
    }

    public int getManaBacklog(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_MANA_BACKLOG, 0);
    }

    public void setManaBacklog(ItemStack stack, int backlog) {
        ItemNBTHelper.setInt(stack, TAG_MANA_BACKLOG, backlog);
    }

    @Override
    public int getMaxMana(ItemStack stack) {
        return 1000000;
    }

    @Override
    public void addMana(ItemStack stack, int mana) {
        this.setMana(stack, this.getMana(stack) + mana);
        this.setManaBacklog(stack, this.getManaBacklog(stack) + mana);
    }

    public void bindPool(ItemStack stack, TileEntity pool) {
        GlobalPos pos = GlobalPos.func_239648_a_((RegistryKey)pool.func_145831_w().func_234923_W_(), (BlockPos)pool.func_174877_v());
        INBT ser = (INBT)GlobalPos.field_239645_a_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)pos).get().orThrow();
        ItemNBTHelper.set(stack, TAG_POS, ser);
    }

    @Nullable
    public IManaPool getManaPool(ItemStack stack) {
        TileEntity tile;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return fallbackPool;
        }
        if (!stack.func_196082_o().func_74764_b(TAG_POS)) {
            return fallbackPool;
        }
        Optional pos = GlobalPos.field_239645_a_.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)ItemNBTHelper.get(stack, TAG_POS)).result();
        if (!pos.isPresent()) {
            return fallbackPool;
        }
        BlockPos coords = ((GlobalPos)pos.get()).func_218180_b();
        if (coords.func_177956_o() == -1) {
            return null;
        }
        RegistryKey type = ((GlobalPos)pos.get()).func_239646_a_();
        ServerWorld world = server.func_71218_a(type);
        if (world != null && (tile = world.func_175625_s(coords)) instanceof IManaPool) {
            return (IManaPool)tile;
        }
        return null;
    }

    @Override
    public boolean canReceiveManaFromPool(ItemStack stack, TileEntity pool) {
        return false;
    }

    @Override
    public boolean canReceiveManaFromItem(ItemStack stack, ItemStack otherStack) {
        return false;
    }

    @Override
    public boolean canExportManaToPool(ItemStack stack, TileEntity pool) {
        return false;
    }

    @Override
    public boolean canExportManaToItem(ItemStack stack, ItemStack otherStack) {
        return true;
    }

    @Override
    public boolean isNoExport(ItemStack stack) {
        return false;
    }

    @Override
    public BlockPos getBinding(ItemStack stack) {
        IManaPool pool = this.getManaPool(stack);
        return pool == null || pool instanceof DummyPool ? null : ((TileEntity)pool).func_174877_v();
    }

    @Override
    public float getManaFractionForDisplay(ItemStack stack) {
        return (float)this.getMana(stack) / (float)this.getMaxMana(stack);
    }

    private static class DummyPool
    implements IManaPool {
        private DummyPool() {
        }

        @Override
        public boolean isFull() {
            return false;
        }

        @Override
        public void receiveMana(int mana) {
        }

        @Override
        public boolean canReceiveManaFromBursts() {
            return false;
        }

        @Override
        public int getCurrentMana() {
            return 0;
        }

        @Override
        public boolean isOutputtingPower() {
            return false;
        }

        @Override
        public DyeColor getColor() {
            return DyeColor.WHITE;
        }

        @Override
        public void setColor(DyeColor color) {
        }
    }
}

